/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.jpa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmExpressableAccessor;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.service.ServiceRegistry;

public class ParameterCollector
extends BaseSemanticQueryWalker {
    private Set<SqmParameter<?>> parameterExpressions;
    private final Consumer<SqmParameter<?>> consumer;
    private SqmExpressableAccessor<?> inferenceBasis;

    public static Set<SqmParameter<?>> collectParameters(SqmStatement<?> statement, Consumer<SqmParameter<?>> consumer, ServiceRegistry serviceRegistry) {
        ParameterCollector collector = new ParameterCollector(serviceRegistry, consumer);
        statement.accept(collector);
        return collector.parameterExpressions == null ? Collections.emptySet() : collector.parameterExpressions;
    }

    private ParameterCollector(ServiceRegistry serviceRegistry, Consumer<SqmParameter<?>> consumer) {
        super(serviceRegistry);
        this.consumer = consumer;
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter<?> expression) {
        return this.visitParameter(expression);
    }

    @Override
    public Object visitNamedParameterExpression(SqmNamedParameter<?> expression) {
        return this.visitParameter(expression);
    }

    @Override
    public SqmJpaCriteriaParameterWrapper<?> visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        return this.visitParameter(new SqmJpaCriteriaParameterWrapper(this.getInferredParameterType(expression), expression, expression.nodeBuilder()));
    }

    private <T> AllowableParameterType<T> getInferredParameterType(JpaCriteriaParameter<?> expression) {
        SqmExpressable<?> expressable;
        AllowableParameterType parameterType = null;
        if (this.inferenceBasis != null && (expressable = this.inferenceBasis.getExpressable()) instanceof AllowableParameterType) {
            parameterType = (AllowableParameterType)expressable;
        }
        if (parameterType == null) {
            parameterType = expression.getHibernateType();
        }
        return parameterType;
    }

    private <T extends SqmParameter<?>> T visitParameter(T param) {
        if (this.parameterExpressions == null) {
            this.parameterExpressions = new HashSet();
        }
        this.parameterExpressions.add(param);
        this.consumer.accept(param);
        return param;
    }

    private <T> SqmJpaCriteriaParameterWrapper<T> visitParameter(SqmJpaCriteriaParameterWrapper<T> param) {
        if (this.parameterExpressions == null) {
            this.parameterExpressions = new HashSet();
        }
        this.parameterExpressions.add(param.getJpaCriteriaParameter());
        this.consumer.accept(param);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withTypeInference(SqmExpressableAccessor<?> inferenceBasis, Runnable action) {
        SqmExpressableAccessor<?> original = this.inferenceBasis;
        this.inferenceBasis = inferenceBasis;
        try {
            action.run();
        }
        finally {
            this.inferenceBasis = original;
        }
    }

    @Override
    public Object visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        SqmExpressableAccessor<?> inferenceSupplier = this.inferenceBasis;
        this.withTypeInference(() -> {
            for (SqmCaseSimple.WhenFragment whenFragment : expression.getWhenFragments()) {
                SqmExpressable resolved = whenFragment.getCheckValue().getExpressable();
                if (!(resolved instanceof AllowableParameterType)) continue;
                return resolved;
            }
            return null;
        }, () -> expression.getFixture().accept(this));
        SqmExpressableAccessor<?> resolved = this.determineCurrentExpressable(expression);
        for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
            this.withTypeInference(expression.getFixture(), () -> whenFragment.getCheckValue().accept(this));
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, () -> whenFragment.getResult().accept(this));
            resolved = this.highestPrecedence(resolved, whenFragment.getResult());
        }
        if (expression.getOtherwise() != null) {
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, () -> expression.getOtherwise().accept(this));
        }
        return expression;
    }

    @Override
    public Object visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        SqmExpressableAccessor<?> inferenceSupplier = this.inferenceBasis;
        SqmExpressableAccessor<?> resolved = this.determineCurrentExpressable(expression);
        for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
            this.withTypeInference(null, () -> whenFragment.getPredicate().accept(this));
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, () -> whenFragment.getResult().accept(this));
            resolved = this.highestPrecedence(resolved, whenFragment.getResult());
        }
        if (expression.getOtherwise() != null) {
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, () -> expression.getOtherwise().accept(this));
        }
        return expression;
    }

    private SqmExpressableAccessor<?> highestPrecedence(SqmExpressableAccessor<?> type1, SqmExpressableAccessor<?> type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.getExpressable() instanceof AllowableParameterType) {
            return type1;
        }
        if (type2.getExpressable() instanceof AllowableParameterType) {
            return type2;
        }
        return type1;
    }

    private SqmExpressableAccessor<?> determineCurrentExpressable(SqmExpression<?> expression) {
        if (expression.getExpressable() instanceof AllowableParameterType) {
            return () -> expression.getExpressable();
        }
        return null;
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath<?> path) {
        path.getLhs().accept(this);
        this.withTypeInference(path.getPluralAttribute().getIndexPathSource(), () -> path.getSelectorExpression().accept(this));
        return path;
    }

    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        this.withTypeInference(null, () -> super.visitIsEmptyPredicate(predicate));
        return predicate;
    }

    @Override
    public Object visitIsNullPredicate(SqmNullnessPredicate predicate) {
        this.withTypeInference(null, () -> super.visitIsNullPredicate(predicate));
        return predicate;
    }

    @Override
    public Object visitComparisonPredicate(SqmComparisonPredicate predicate) {
        this.withTypeInference(predicate.getRightHandExpression(), () -> predicate.getLeftHandExpression().accept(this));
        this.withTypeInference(predicate.getLeftHandExpression(), () -> predicate.getRightHandExpression().accept(this));
        return predicate;
    }

    @Override
    public Object visitBetweenPredicate(SqmBetweenPredicate predicate) {
        this.withTypeInference(predicate.getLowerBound(), () -> predicate.getExpression().accept(this));
        this.withTypeInference(predicate.getExpression(), () -> {
            predicate.getLowerBound().accept(this);
            predicate.getUpperBound().accept(this);
        });
        return predicate;
    }

    @Override
    public Object visitLikePredicate(SqmLikePredicate predicate) {
        this.withTypeInference(predicate.getPattern(), () -> predicate.getMatchExpression().accept(this));
        this.withTypeInference(predicate.getMatchExpression(), () -> {
            predicate.getPattern().accept(this);
            if (predicate.getEscapeCharacter() != null) {
                predicate.getEscapeCharacter().accept(this);
            }
        });
        return predicate;
    }

    @Override
    public Object visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        this.withTypeInference(predicate.getPluralPath(), () -> predicate.getLeftHandExpression().accept(this));
        predicate.getPluralPath().accept(this);
        return predicate;
    }

    @Override
    public Object visitInListPredicate(SqmInListPredicate<?> predicate) {
        SqmExpression<?> firstListElement = predicate.getListExpressions().isEmpty() ? null : predicate.getListExpressions().get(0);
        this.withTypeInference(firstListElement, () -> predicate.getTestExpression().accept(this));
        this.withTypeInference(predicate.getTestExpression(), () -> {
            for (SqmExpression expression : predicate.getListExpressions()) {
                expression.accept(this);
            }
        });
        return predicate;
    }

    @Override
    public Object visitInSubQueryPredicate(SqmInSubQueryPredicate<?> predicate) {
        this.withTypeInference(predicate.getSubQueryExpression(), () -> predicate.getTestExpression().accept(this));
        this.withTypeInference(predicate.getTestExpression(), () -> predicate.getSubQueryExpression().accept(this));
        return predicate;
    }
}

