/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmLikePredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> matchExpression;
    private final SqmExpression<?> pattern;
    private final SqmExpression<?> escapeCharacter;
    private final boolean isCaseSensitive;

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, SqmExpression<?> escapeCharacter, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, escapeCharacter, false, nodeBuilder);
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, SqmExpression<?> escapeCharacter, boolean negated, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, escapeCharacter, negated, true, nodeBuilder);
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, SqmExpression<?> escapeCharacter, boolean negated, boolean isCaseSensitive, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.matchExpression = matchExpression;
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
        this.isCaseSensitive = isCaseSensitive;
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, null, nodeBuilder);
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, boolean negated, boolean isCaseSensitive, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, null, negated, isCaseSensitive, nodeBuilder);
    }

    public SqmExpression<?> getMatchExpression() {
        return this.matchExpression;
    }

    public SqmExpression<?> getPattern() {
        return this.pattern;
    }

    public SqmExpression<?> getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitLikePredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.matchExpression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" not");
        }
        sb.append(" like ");
        this.pattern.appendHqlString(sb);
        if (this.escapeCharacter != null) {
            sb.append(" escape ");
            this.escapeCharacter.appendHqlString(sb);
        }
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmLikePredicate(this.matchExpression, this.pattern, this.escapeCharacter, !this.isNegated(), (NodeBuilder)this.nodeBuilder());
    }
}

