/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Arrays;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctivePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmOrPredicate
extends AbstractSqmExpression<Boolean>
implements SqmJunctivePredicate {
    private final SqmPredicate leftHandPredicate;
    private final SqmPredicate rightHandPredicate;

    public SqmOrPredicate(SqmPredicate leftHandPredicate, SqmPredicate rightHandPredicate, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        this.leftHandPredicate = leftHandPredicate;
        this.rightHandPredicate = rightHandPredicate;
    }

    @Override
    public SqmPredicate getLeftHandPredicate() {
        return this.leftHandPredicate;
    }

    @Override
    public SqmPredicate getRightHandPredicate() {
        return this.rightHandPredicate;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitOrPredicate(this);
    }

    @Override
    public SqmPredicate not() {
        return new SqmNegatedPredicate(this, (NodeBuilder)this.nodeBuilder());
    }

    public Predicate.BooleanOperator getOperator() {
        return Predicate.BooleanOperator.OR;
    }

    public boolean isNegated() {
        return false;
    }

    public List<Expression<Boolean>> getExpressions() {
        return Arrays.asList(this.leftHandPredicate, this.rightHandPredicate);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.leftHandPredicate instanceof SqmAndPredicate) {
            sb.append('(');
            this.leftHandPredicate.appendHqlString(sb);
            sb.append(')');
        } else {
            this.leftHandPredicate.appendHqlString(sb);
        }
        sb.append(" or ");
        if (this.rightHandPredicate instanceof SqmAndPredicate) {
            sb.append('(');
            this.rightHandPredicate.appendHqlString(sb);
            sb.append(')');
        } else {
            this.rightHandPredicate.appendHqlString(sb);
        }
    }
}

