/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.Collections;
import java.util.List;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;

public abstract class SqmQueryPart<T>
implements SqmVisitableNode,
JpaQueryPart<T> {
    private final NodeBuilder nodeBuilder;
    private SqmOrderByClause orderByClause;
    private SqmExpression<?> offsetExpression;
    private SqmExpression<?> fetchExpression;
    private FetchClauseType fetchClauseType = FetchClauseType.ROWS_ONLY;

    public SqmQueryPart(NodeBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    public abstract SqmQuerySpec<T> getFirstQuerySpec();

    public abstract SqmQuerySpec<T> getLastQuerySpec();

    public abstract boolean isSimpleQueryPart();

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    public SqmOrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(SqmOrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    public SqmExpression<?> getFetchExpression() {
        return this.fetchExpression;
    }

    public SqmExpression<?> getOffsetExpression() {
        return this.offsetExpression;
    }

    public void setOffsetExpression(SqmExpression<?> offsetExpression) {
        if (offsetExpression != null) {
            offsetExpression.applyInferableType(this.nodeBuilder.getIntegerType());
        }
        this.offsetExpression = offsetExpression;
    }

    public void setFetchExpression(SqmExpression<?> fetchExpression) {
        this.setFetchExpression(fetchExpression, FetchClauseType.ROWS_ONLY);
    }

    public void setFetchExpression(SqmExpression<?> fetchExpression, FetchClauseType fetchClauseType) {
        if (fetchExpression == null) {
            this.fetchExpression = null;
            this.fetchClauseType = null;
        } else {
            if (fetchClauseType == null) {
                throw new IllegalArgumentException("Fetch clause may not be null!");
            }
            fetchExpression.applyInferableType(this.nodeBuilder.getIntegerType());
            this.fetchExpression = fetchExpression;
            this.fetchClauseType = fetchClauseType;
        }
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return this.fetchClauseType;
    }

    @Override
    public List<SqmSortSpecification> getSortSpecifications() {
        if (this.getOrderByClause() == null) {
            return Collections.emptyList();
        }
        return this.getOrderByClause().getSortSpecifications();
    }

    @Override
    public SqmQueryPart<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        if (this.getOrderByClause() == null) {
            this.setOrderByClause(new SqmOrderByClause());
        }
        this.getOrderByClause().setSortSpecifications(sortSpecifications);
        return this;
    }

    @Override
    public SqmExpression<?> getOffset() {
        return this.getOffsetExpression();
    }

    @Override
    public SqmQueryPart<T> setOffset(JpaExpression<?> offset) {
        this.setOffsetExpression((SqmExpression)offset);
        return this;
    }

    @Override
    public SqmExpression<?> getFetch() {
        return this.getFetchExpression();
    }

    @Override
    public SqmQueryPart<T> setFetch(JpaExpression<?> fetch) {
        this.setFetchExpression((SqmExpression)fetch);
        return this;
    }

    @Override
    public JpaQueryPart<T> setFetch(JpaExpression<?> fetch, FetchClauseType fetchClauseType) {
        this.setFetchExpression((SqmExpression)fetch, fetchClauseType);
        return this;
    }

    public abstract void validateFetchStructureAndOwners();

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.orderByClause == null) {
            return;
        }
        sb.append(" order by ");
        List<SqmSortSpecification> sortSpecifications = this.orderByClause.getSortSpecifications();
        sortSpecifications.get(0).appendHqlString(sb);
        for (int i = 1; i < sortSpecifications.size(); ++i) {
            sb.append(", ");
            sortSpecifications.get(i).appendHqlString(sb);
        }
        if (this.offsetExpression != null) {
            sb.append(" offset ");
            this.offsetExpression.appendHqlString(sb);
            sb.append(" rows ");
        }
        if (this.fetchExpression != null) {
            sb.append(" fetch first ");
            this.fetchExpression.appendHqlString(sb);
            switch (this.fetchClauseType) {
                case ROWS_ONLY: {
                    sb.append(" rows only");
                    break;
                }
                case ROWS_WITH_TIES: {
                    sb.append(" rows with ties");
                    break;
                }
                case PERCENT_ONLY: {
                    sb.append(" percent only");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    sb.append(" percent with ties");
                }
            }
        }
    }
}

