/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.result.internal;

import jakarta.persistence.ParameterMode;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.JDBCException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.internal.ScalarDomainResultBuilder;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.result.Output;
import org.hibernate.result.Outputs;
import org.hibernate.result.internal.ResultSetOutputImpl;
import org.hibernate.result.internal.UpdateCountOutputImpl;
import org.hibernate.result.spi.ResultContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.NoMoreOutputsException;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.jdbc.internal.DirectResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.jboss.logging.Logger;

public class OutputsImpl
implements Outputs {
    private static final Logger log = CoreLogging.logger(OutputsImpl.class);
    private final ResultContext context;
    private final PreparedStatement jdbcStatement;
    private CurrentReturnState currentReturnState;

    public OutputsImpl(ResultContext context, PreparedStatement jdbcStatement) {
        this.context = context;
        this.jdbcStatement = jdbcStatement;
        try {
            boolean isResultSet = jdbcStatement.execute();
            this.currentReturnState = this.buildCurrentReturnState(isResultSet);
        }
        catch (SQLException e) {
            throw this.convert(e, "Error calling CallableStatement.getMoreResults");
        }
    }

    private CurrentReturnState buildCurrentReturnState(boolean isResultSet) {
        int updateCount = -1;
        if (!isResultSet) {
            try {
                updateCount = this.jdbcStatement.getUpdateCount();
            }
            catch (SQLException e) {
                throw this.convert(e, "Error calling CallableStatement.getUpdateCount");
            }
        }
        return this.buildCurrentReturnState(isResultSet, updateCount);
    }

    protected CurrentReturnState buildCurrentReturnState(boolean isResultSet, int updateCount) {
        return new CurrentReturnState(isResultSet, updateCount);
    }

    protected JDBCException convert(SQLException e, String message) {
        return this.context.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, message, this.jdbcStatement.toString());
    }

    @Override
    public Output getCurrent() {
        if (this.currentReturnState == null) {
            return null;
        }
        return this.currentReturnState.getOutput();
    }

    @Override
    public boolean goToNext() {
        if (this.currentReturnState == null) {
            return false;
        }
        if (this.currentReturnState.indicatesMoreOutputs()) {
            try {
                boolean isResultSet = this.jdbcStatement.getMoreResults();
                this.currentReturnState = this.buildCurrentReturnState(isResultSet);
            }
            catch (SQLException e) {
                throw this.convert(e, "Error calling CallableStatement.getMoreResults");
            }
        }
        return this.currentReturnState != null && this.currentReturnState.indicatesMoreOutputs();
    }

    @Override
    public void release() {
        try {
            this.jdbcStatement.close();
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to close PreparedStatement", (Throwable)e);
        }
    }

    private List extractCurrentResults() {
        try {
            return this.extractResults(this.jdbcStatement.getResultSet());
        }
        catch (SQLException e) {
            throw this.convert(e, "Error calling CallableStatement.getResultSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List extractResults(ResultSet resultSet) {
        DirectResultSetAccess resultSetAccess = new DirectResultSetAccess(this.context.getSession(), this.jdbcStatement, resultSet);
        ProcedureCallImpl procedureCall = (ProcedureCallImpl)this.context;
        ResultSetMapping resultSetMapping = procedureCall.getResultSetMapping();
        JavaTypeRegistry javaTypeRegistry = this.context.getSession().getTypeConfiguration().getJavaTypeDescriptorRegistry();
        procedureCall.getParameterBindings().visitBindings((parameterImplementor, queryParameterBinding) -> {
            ProcedureParameter parameter = (ProcedureParameter)((Object)parameterImplementor);
            if (parameter.getMode() == ParameterMode.INOUT) {
                JavaType basicType = javaTypeRegistry.getDescriptor(parameterImplementor.getParameterType());
                if (basicType != null) {
                    resultSetMapping.addResultBuilder(new ScalarDomainResultBuilder(basicType));
                } else {
                    throw new NotYetImplementedFor6Exception(this.getClass());
                }
            }
        });
        ExecutionContext executionContext = new ExecutionContext(){
            private final Callback callback = new CallbackImpl();

            @Override
            public SharedSessionContractImplementor getSession() {
                return OutputsImpl.this.context.getSession();
            }

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptionsAdapter(){

                    @Override
                    public Boolean isReadOnly() {
                        return false;
                    }
                };
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return this.callback;
            }
        };
        JdbcValuesResultSetImpl jdbcValues = new JdbcValuesResultSetImpl(resultSetAccess, null, null, this.context.getQueryOptions(), resultSetMapping.resolve(resultSetAccess, this.getSessionFactory()), null, executionContext);
        RowReader rowReader = ResultsHelper.createRowReader(executionContext, null, RowTransformerPassThruImpl.INSTANCE, jdbcValues);
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return null;
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Serializable getEffectiveOptionalId() {
                return null;
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions, executionContext::registerLoadingEntityEntry);
        try {
            RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(jdbcValuesSourceProcessingState, executionContext, rowReader, jdbcValues);
            ArrayList results = new ArrayList();
            while (rowProcessingState.next()) {
                results.add(rowReader.readRow(rowProcessingState, processingOptions));
                rowProcessingState.finishRowProcessing();
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            rowReader.finishUp(jdbcValuesSourceProcessingState);
            jdbcValuesSourceProcessingState.finishUp();
            jdbcValues.finishUp(this.context.getSession());
        }
    }

    private SessionFactoryImplementor getSessionFactory() {
        return this.context.getSession().getFactory();
    }

    protected class CurrentReturnState {
        private final boolean isResultSet;
        private final int updateCount;
        private Output rtn;

        protected CurrentReturnState(boolean isResultSet, int updateCount) {
            this.isResultSet = isResultSet;
            this.updateCount = updateCount;
        }

        public boolean indicatesMoreOutputs() {
            return this.isResultSet() || this.getUpdateCount() >= 0;
        }

        public boolean isResultSet() {
            return this.isResultSet;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public Output getOutput() {
            if (this.rtn == null) {
                this.rtn = this.buildOutput();
            }
            return this.rtn;
        }

        protected Output buildOutput() {
            if (log.isDebugEnabled()) {
                log.debugf("Building Return [isResultSet=%s, updateCount=%s, extendedReturn=%s]", (Object)this.isResultSet(), (Object)this.getUpdateCount(), (Object)this.hasExtendedReturns());
            }
            if (this.isResultSet()) {
                return this.buildResultSetOutput(OutputsImpl.this.extractCurrentResults());
            }
            if (this.getUpdateCount() >= 0) {
                return this.buildUpdateCountOutput(this.updateCount);
            }
            if (this.hasExtendedReturns()) {
                return this.buildExtendedReturn();
            }
            throw new NoMoreOutputsException();
        }

        protected Output buildResultSetOutput(List list) {
            return new ResultSetOutputImpl(list);
        }

        protected Output buildResultSetOutput(Supplier<List> listSupplier) {
            return new ResultSetOutputImpl(listSupplier);
        }

        protected Output buildUpdateCountOutput(int updateCount) {
            return new UpdateCountOutputImpl(updateCount);
        }

        protected boolean hasExtendedReturns() {
            return false;
        }

        protected Output buildExtendedReturn() {
            throw new IllegalStateException("State does not define extended returns");
        }
    }
}

