/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast;

import java.util.List;
import org.hibernate.sql.ast.tree.SqlAstTreeLogger;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;

public class SqlTreePrinter {
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;

    public static void logSqlAst(Statement sqlAstStatement) {
        if (!SqlAstTreeLogger.DEBUG_ENABLED) {
            return;
        }
        SqlTreePrinter printer = new SqlTreePrinter();
        printer.visitStatement(sqlAstStatement);
        SqlAstTreeLogger.INSTANCE.debugf("SQL AST Tree:%n" + printer.buffer.toString(), new Object[0]);
    }

    private SqlTreePrinter() {
    }

    private void visitStatement(Statement sqlAstStatement) {
        if (sqlAstStatement instanceof SelectStatement) {
            SelectStatement selectStatement = (SelectStatement)sqlAstStatement;
            this.logNode("SelectStatement", () -> this.visitFromClause(selectStatement.getQuerySpec().getFromClause()));
        } else if (sqlAstStatement instanceof DeleteStatement) {
            DeleteStatement deleteStatement = (DeleteStatement)sqlAstStatement;
            this.logNode("DeleteStatement", () -> this.logWithIndentation("target : " + deleteStatement.getTargetTable().getTableExpression()));
        } else if (sqlAstStatement instanceof UpdateStatement) {
            UpdateStatement updateStatement = (UpdateStatement)sqlAstStatement;
            this.logNode("UpdateStatement", () -> this.logWithIndentation("target : " + updateStatement.getTargetTable().getTableExpression()));
        } else if (sqlAstStatement instanceof InsertStatement) {
            InsertStatement insertStatement = (InsertStatement)sqlAstStatement;
            this.logNode("InsertStatement", () -> this.logWithIndentation("target : " + insertStatement.getTargetTable().getTableExpression()));
        } else {
            throw new UnsupportedOperationException("Printing for this type of SQL AST not supported : " + sqlAstStatement);
        }
    }

    private void visitFromClause(FromClause fromClause) {
        this.logNode("FromClause", () -> fromClause.visitRoots(this::visitTableGroup));
    }

    private void visitTableGroup(TableGroup tableGroup) {
        this.logNode(this.toDisplayText(tableGroup), () -> this.logTableGroupDetails(tableGroup));
    }

    private String toDisplayText(TableGroup tableGroup) {
        return tableGroup.getClass().getSimpleName() + " (" + tableGroup.getGroupAlias() + " : " + tableGroup.getNavigablePath() + ")";
    }

    private void logTableGroupDetails(TableGroup tableGroup) {
        List<TableGroupJoin> tableGroupJoins;
        List<TableGroupJoin> nestedTableGroupJoins;
        if (tableGroup instanceof LazyTableGroup) {
            TableGroup underlyingTableGroup = ((LazyTableGroup)tableGroup).getUnderlyingTableGroup();
            if (underlyingTableGroup != null) {
                this.logTableGroupDetails(underlyingTableGroup);
            }
            return;
        }
        this.logWithIndentation("primaryTableReference : %s as %s", tableGroup.getPrimaryTableReference().getTableExpression(), tableGroup.getPrimaryTableReference().getIdentificationVariable());
        List<TableReferenceJoin> tableReferenceJoins = tableGroup.getTableReferenceJoins();
        if (!tableReferenceJoins.isEmpty()) {
            this.logNode("TableReferenceJoins", () -> {
                for (TableReferenceJoin join : tableReferenceJoins) {
                    this.logWithIndentation("%s join %s as %s", join.getJoinType().getText(), join.getJoinedTableReference().getTableExpression(), join.getJoinedTableReference().getIdentificationVariable());
                }
            });
        }
        if (!(nestedTableGroupJoins = tableGroup.getNestedTableGroupJoins()).isEmpty()) {
            this.logNode("NestedTableGroupJoins", () -> tableGroup.visitNestedTableGroupJoins(this::visitTableGroupJoin));
        }
        if (!(tableGroupJoins = tableGroup.getTableGroupJoins()).isEmpty()) {
            this.logNode("TableGroupJoins", () -> tableGroup.visitTableGroupJoins(this::visitTableGroupJoin));
        }
    }

    private void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        this.logNode(tableGroupJoin.getJoinType().getText() + " join " + this.toDisplayText(tableGroupJoin.getJoinedGroup()), () -> this.logTableGroupDetails(tableGroupJoin.getJoinedGroup()));
    }

    private void logNode(String text) {
        this.logWithIndentation("%s", text);
    }

    private void logNode(String text, Runnable subTreeHandler) {
        this.logNode(text, subTreeHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logNode(String text, Runnable subTreeHandler, boolean indentContinuation) {
        this.logWithIndentation("%s {", text);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            subTreeHandler.run();
        }
        catch (Exception e) {
            SqlAstTreeLogger.INSTANCE.debugf(e, "Error processing node {%s}", text);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("}", text);
    }

    private void logWithIndentation(Object line) {
        this.pad(this.depth);
        this.buffer.append(line).append(System.lineSeparator());
    }

    private void logWithIndentation(String pattern, Object arg1) {
        this.logWithIndentation(String.format(pattern, arg1));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2) {
        this.logWithIndentation(String.format(pattern, arg1, arg2));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2, Object arg3) {
        this.logWithIndentation(String.format(pattern, arg1, arg2, arg3));
    }

    private void pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
    }
}

