/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class SimpleFromClauseAccessImpl
implements FromClauseAccess {
    protected final FromClauseAccess parent;
    protected final Map<NavigablePath, TableGroup> tableGroupMap = new HashMap<NavigablePath, TableGroup>();

    public SimpleFromClauseAccessImpl() {
        this(null);
    }

    public SimpleFromClauseAccessImpl(FromClauseAccess parent) {
        this.parent = parent;
    }

    @Override
    public TableGroup findTableGroupOnLeaf(NavigablePath navigablePath) {
        return this.tableGroupMap.get(navigablePath);
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        TableGroup tableGroup = this.tableGroupMap.get(navigablePath);
        if (tableGroup == null && this.parent != null) {
            return this.parent.findTableGroup(navigablePath);
        }
        return tableGroup;
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        SqlTreeCreationLogger.LOGGER.debugf("Registration of TableGroup [%s] with identifierForTableGroup [%s] for NavigablePath [%s] ", (Object)tableGroup, (Object)tableGroup.getNavigablePath().getIdentifierForTableGroup(), (Object)navigablePath.getIdentifierForTableGroup());
        TableGroup previous = this.tableGroupMap.put(navigablePath, tableGroup);
        if (previous != null) {
            SqlTreeCreationLogger.LOGGER.debugf("Registration of TableGroup [%s] for NavigablePath [%s] overrode previous registration : %s", (Object)tableGroup, (Object)navigablePath, (Object)previous);
        }
    }
}

