/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.sql.ast.tree.AbstractStatement;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;

public abstract class AbstractMutationStatement
extends AbstractStatement
implements MutationStatement {
    private final TableReference targetTable;
    private final List<ColumnReference> returningColumns;

    public AbstractMutationStatement(TableReference targetTable) {
        super(new LinkedHashMap<String, CteStatement>());
        this.targetTable = targetTable;
        this.returningColumns = Collections.emptyList();
    }

    public AbstractMutationStatement(Map<String, CteStatement> cteStatements, TableReference targetTable, List<ColumnReference> returningColumns) {
        super(cteStatements);
        this.targetTable = targetTable;
        this.returningColumns = returningColumns;
    }

    @Override
    public TableReference getTargetTable() {
        return this.targetTable;
    }

    @Override
    public List<ColumnReference> getReturningColumns() {
        return this.returningColumns;
    }
}

