/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;

public abstract class AbstractTableGroup
extends AbstractColumnReferenceQualifier
implements TableGroup {
    private final boolean canUseInnerJoins;
    private final NavigablePath navigablePath;
    private final TableGroupProducer producer;
    private final String sourceAlias;
    private final SqlAliasBase sqlAliasBase;
    private List<TableGroupJoin> tableGroupJoins;
    private List<TableGroupJoin> nestedTableGroupJoins;
    private final SessionFactoryImplementor sessionFactory;

    public AbstractTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, TableGroupProducer producer, String sourceAlias, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        this.canUseInnerJoins = canUseInnerJoins;
        this.navigablePath = navigablePath;
        this.producer = producer;
        this.sourceAlias = sourceAlias;
        this.sqlAliasBase = sqlAliasBase;
        this.sessionFactory = sessionFactory;
    }

    public SqlAliasBase getSqlAliasBase() {
        return this.sqlAliasBase;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return this.sqlAliasBase.getAliasStem();
    }

    @Override
    public TableGroupProducer getModelPart() {
        return this.producer;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getSourceAlias() {
        return this.sourceAlias;
    }

    @Override
    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.tableGroupJoins);
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        return this.nestedTableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.nestedTableGroupJoins);
    }

    @Override
    public boolean isRealTableGroup() {
        return this.nestedTableGroupJoins != null && !this.nestedTableGroupJoins.isEmpty();
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.canUseInnerJoins;
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        assert (!this.tableGroupJoins.contains(join));
        this.tableGroupJoins.add(join);
    }

    @Override
    public void addNestedTableGroupJoin(TableGroupJoin join) {
        if (this.nestedTableGroupJoins == null) {
            this.nestedTableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        assert (!this.nestedTableGroupJoins.contains(join));
        this.nestedTableGroupJoins.add(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.nestedTableGroupJoins != null) {
            this.nestedTableGroupJoins.forEach(consumer);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getNavigablePath() + ")";
    }
}

