/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class StandardVirtualTableGroup
implements VirtualTableGroup {
    private final NavigablePath navigablePath;
    private final ModelPartContainer modelPart;
    private final TableGroup underlyingTableGroup;
    private final boolean fetched;
    private List<TableGroupJoin> tableGroupJoins;
    private List<TableGroupJoin> nestedTableGroupJoins;

    public StandardVirtualTableGroup(NavigablePath navigablePath, ModelPartContainer modelPart, TableGroup underlyingTableGroup, boolean fetched) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.underlyingTableGroup = underlyingTableGroup;
        this.fetched = fetched;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPartContainer getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.modelPart;
    }

    @Override
    public String getSourceAlias() {
        return this.underlyingTableGroup.getSourceAlias();
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.tableGroupJoins);
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        return this.nestedTableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.nestedTableGroupJoins);
    }

    @Override
    public boolean isRealTableGroup() {
        return this.nestedTableGroupJoins != null && !this.nestedTableGroupJoins.isEmpty();
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.underlyingTableGroup.canUseInnerJoins();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        assert (!this.tableGroupJoins.contains(join));
        this.tableGroupJoins.add(join);
    }

    @Override
    public void addNestedTableGroupJoin(TableGroupJoin join) {
        if (this.nestedTableGroupJoins == null) {
            this.nestedTableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        assert (!this.nestedTableGroupJoins.contains(join));
        this.nestedTableGroupJoins.add(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.nestedTableGroupJoins != null) {
            this.nestedTableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.underlyingTableGroup.applyAffectedTableNames(nameCollector);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.underlyingTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.underlyingTableGroup.getTableReferenceJoins();
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        TableReference tableReference = this.getTableReference(navigablePath, tableExpression, allowFkOptimization, true);
        if (tableReference == null) {
            throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference primaryTableReference;
        TableReference tableReference = this.underlyingTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getNestedTableGroupJoins()) {
            primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (primaryTableReference == null) continue;
            return primaryTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (primaryTableReference == null) continue;
            return primaryTableReference;
        }
        return null;
    }
}

