/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateContainer;

public class TableReferenceJoin
implements TableJoin,
PredicateContainer {
    private final SqlAstJoinType sqlAstJoinType;
    private final TableReference joinedTableBinding;
    private Predicate predicate;

    public TableReferenceJoin(SqlAstJoinType sqlAstJoinType, TableReference joinedTableBinding, Predicate predicate) {
        this.sqlAstJoinType = sqlAstJoinType == null ? SqlAstJoinType.LEFT : sqlAstJoinType;
        this.joinedTableBinding = joinedTableBinding;
        this.predicate = predicate;
    }

    @Override
    public SqlAstJoinType getJoinType() {
        return this.sqlAstJoinType;
    }

    public TableReference getJoinedTableReference() {
        return this.joinedTableBinding;
    }

    @Override
    public SqlAstNode getJoinedNode() {
        return this.joinedTableBinding;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReferenceJoin(this);
    }

    public String toString() {
        return this.getJoinType().getText() + " join " + this.getJoinedTableReference().toString();
    }

    @Override
    public void applyPredicate(Predicate newPredicate) {
        this.predicate = SqlAstTreeHelper.combinePredicates(this.predicate, newPredicate);
    }
}

