/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableReference;

public class UnionTableReference
extends TableReference {
    private final String[] subclassTableSpaceExpressions;

    public UnionTableReference(String unionTableExpression, String[] subclassTableSpaceExpressions, String identificationVariable, boolean isOptional, SessionFactoryImplementor sessionFactory) {
        super(unionTableExpression, identificationVariable, isOptional, sessionFactory);
        this.subclassTableSpaceExpressions = subclassTableSpaceExpressions;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        if (this.hasTableExpression(tableExpression)) {
            return this;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        if (this.hasTableExpression(tableExpression)) {
            return this;
        }
        return null;
    }

    private boolean hasTableExpression(String tableExpression) {
        if (tableExpression.equals(this.getTableExpression())) {
            return true;
        }
        for (String expression : this.subclassTableSpaceExpressions) {
            if (!tableExpression.equals(expression)) continue;
            return true;
        }
        return false;
    }
}

