/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.spi.JdbcCall;
import org.hibernate.sql.exec.spi.JdbcCallFunctionReturn;
import org.hibernate.sql.exec.spi.JdbcCallParameterExtractor;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcCallRefCursorExtractor;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

public class JdbcCallImpl
implements JdbcCall {
    private final String callableName;
    private final JdbcCallFunctionReturn functionReturn;
    private final List<JdbcCallParameterRegistration> parameterRegistrations;
    private final List<JdbcParameterBinder> parameterBinders;
    private final List<JdbcCallParameterExtractor> parameterExtractors;
    private final List<JdbcCallRefCursorExtractor> refCursorExtractors;

    public JdbcCallImpl(Builder builder) {
        this.callableName = builder.callableName;
        this.functionReturn = builder.functionReturn;
        this.parameterRegistrations = builder.parameterRegistrations == null ? Collections.emptyList() : Collections.unmodifiableList(builder.parameterRegistrations);
        this.parameterBinders = builder.parameterBinders == null ? Collections.emptyList() : Collections.unmodifiableList(builder.parameterBinders);
        this.parameterExtractors = builder.parameterExtractors == null ? Collections.emptyList() : Collections.unmodifiableList(builder.parameterExtractors);
        this.refCursorExtractors = builder.refCursorExtractors == null ? Collections.emptyList() : Collections.unmodifiableList(builder.refCursorExtractors);
    }

    @Override
    public String getSql() {
        return this.callableName;
    }

    @Override
    public JdbcCallFunctionReturn getFunctionReturn() {
        return this.functionReturn;
    }

    @Override
    public List<JdbcCallParameterRegistration> getParameterRegistrations() {
        return this.parameterRegistrations == null ? Collections.emptyList() : this.parameterRegistrations;
    }

    @Override
    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders == null ? Collections.emptyList() : this.parameterBinders;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Set<FilterJdbcParameter> getFilterJdbcParameters() {
        return null;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        return false;
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        return true;
    }

    @Override
    public List<JdbcCallParameterExtractor> getParameterExtractors() {
        return this.parameterExtractors == null ? Collections.emptyList() : this.parameterExtractors;
    }

    @Override
    public List<JdbcCallRefCursorExtractor> getCallRefCursorExtractors() {
        return this.refCursorExtractors == null ? Collections.emptyList() : this.refCursorExtractors;
    }

    @Override
    public JdbcValuesMappingProducer getJdbcValuesMappingProducer() {
        return null;
    }

    public static class Builder {
        private final String callableName;
        private final ParameterStrategy parameterStrategy;
        private JdbcCallFunctionReturn functionReturn;
        private List<JdbcCallParameterRegistration> parameterRegistrations;
        private List<JdbcParameterBinder> parameterBinders;
        private List<JdbcCallParameterExtractor> parameterExtractors;
        private List<JdbcCallRefCursorExtractor> refCursorExtractors;

        public Builder(String callableName, ParameterStrategy parameterStrategy) {
            this.callableName = callableName;
            this.parameterStrategy = parameterStrategy;
        }

        public JdbcCall buildJdbcCall() {
            return new JdbcCallImpl(this);
        }

        public void setFunctionReturn(JdbcCallFunctionReturn functionReturn) {
            this.functionReturn = functionReturn;
        }

        public void addParameterRegistration(JdbcCallParameterRegistration registration) {
            if (this.parameterRegistrations == null) {
                this.parameterRegistrations = new ArrayList<JdbcCallParameterRegistration>();
            }
            this.parameterRegistrations.add(registration);
            switch (registration.getParameterMode()) {
                case REF_CURSOR: {
                    this.addRefCursorExtractor(registration.getRefCursorExtractor());
                    break;
                }
                case IN: {
                    this.addParameterBinder(registration.getParameterBinder());
                    break;
                }
                case INOUT: {
                    this.addParameterBinder(registration.getParameterBinder());
                    this.addParameterExtractor(registration.getParameterExtractor());
                    break;
                }
                case OUT: {
                    this.addParameterExtractor(registration.getParameterExtractor());
                    break;
                }
                default: {
                    throw new HibernateException("Unexpected ParameterMode : " + registration.getParameterMode());
                }
            }
        }

        private void addParameterBinder(JdbcParameterBinder binder) {
            if (this.parameterBinders == null) {
                this.parameterBinders = new ArrayList<JdbcParameterBinder>();
            }
            this.parameterBinders.add(binder);
        }

        private void addParameterExtractor(JdbcCallParameterExtractor extractor) {
            if (this.parameterExtractors == null) {
                this.parameterExtractors = new ArrayList<JdbcCallParameterExtractor>();
            }
            this.parameterExtractors.add(extractor);
        }

        private void addRefCursorExtractor(JdbcCallRefCursorExtractor extractor) {
            if (this.refCursorExtractors == null) {
                this.refCursorExtractors = new ArrayList<JdbcCallRefCursorExtractor>();
            }
            this.refCursorExtractors.add(extractor);
        }
    }
}

