/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcCallParameterExtractor;

public class JdbcCallParameterExtractorImpl<T>
implements JdbcCallParameterExtractor {
    private final String callableName;
    private final String parameterName;
    private final int parameterPosition;
    private final BasicDomainType ormType;

    public JdbcCallParameterExtractorImpl(String callableName, String parameterName, int parameterPosition, AllowableParameterType ormType) {
        if (!(ormType instanceof BasicDomainType)) {
            throw new NotYetImplementedFor6Exception("Support for JDBC CallableStatement parameter extraction not yet supported for non-basic types");
        }
        this.callableName = callableName;
        this.parameterName = parameterName;
        this.parameterPosition = parameterPosition;
        this.ormType = (BasicDomainType)ormType;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public int getParameterPosition() {
        return this.parameterPosition;
    }

    @Override
    public T extractValue(CallableStatement callableStatement, boolean shouldUseJdbcNamedParameters, ExecutionContext executionContext) {
        boolean useNamed = shouldUseJdbcNamedParameters && this.parameterName != null;
        try {
            if (useNamed) {
                return (T)this.ormType.extract(callableStatement, this.parameterName, executionContext.getSession());
            }
            return (T)this.ormType.extract(callableStatement, this.parameterPosition, executionContext.getSession());
        }
        catch (SQLException e) {
            throw executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to extract OUT/INOUT parameter value");
        }
    }
}

