/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.AbstractJdbcOperation;
import org.hibernate.sql.exec.spi.JdbcLockStrategy;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

public class JdbcSelect
extends AbstractJdbcOperation {
    private final JdbcValuesMappingProducer jdbcValuesMappingProducer;
    private final int rowsToSkip;
    private final int maxRows;
    private final JdbcParameter offsetParameter;
    private final JdbcParameter limitParameter;
    private final JdbcLockStrategy jdbcLockStrategy;

    public JdbcSelect(String sql, List<JdbcParameterBinder> parameterBinders, JdbcValuesMappingProducer jdbcValuesMappingProducer, Set<String> affectedTableNames, Set<FilterJdbcParameter> filterJdbcParameters) {
        this(sql, parameterBinders, jdbcValuesMappingProducer, affectedTableNames, filterJdbcParameters, 0, Integer.MAX_VALUE, Collections.emptyMap(), JdbcLockStrategy.AUTO, null, null);
    }

    public JdbcSelect(String sql, List<JdbcParameterBinder> parameterBinders, JdbcValuesMappingProducer jdbcValuesMappingProducer, Set<String> affectedTableNames, Set<FilterJdbcParameter> filterJdbcParameters, int rowsToSkip, int maxRows, Map<JdbcParameter, JdbcParameterBinding> appliedParameters, JdbcLockStrategy jdbcLockStrategy, JdbcParameter offsetParameter, JdbcParameter limitParameter) {
        super(sql, parameterBinders, affectedTableNames, filterJdbcParameters, appliedParameters);
        this.jdbcValuesMappingProducer = jdbcValuesMappingProducer;
        this.rowsToSkip = rowsToSkip;
        this.maxRows = maxRows;
        this.jdbcLockStrategy = jdbcLockStrategy;
        this.offsetParameter = offsetParameter;
        this.limitParameter = limitParameter;
    }

    public JdbcValuesMappingProducer getJdbcValuesMappingProducer() {
        return this.jdbcValuesMappingProducer;
    }

    public int getRowsToSkip() {
        return this.rowsToSkip;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public boolean usesLimitParameters() {
        return this.offsetParameter != null || this.limitParameter != null;
    }

    public JdbcLockStrategy getLockStrategy() {
        return this.jdbcLockStrategy;
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (!this.appliedParameters.isEmpty()) {
            if (jdbcParameterBindings == null) {
                return false;
            }
            for (Map.Entry entry : this.appliedParameters.entrySet()) {
                JdbcParameterBinding binding;
                JdbcParameter parameter = (JdbcParameter)entry.getKey();
                JdbcParameterBinding appliedBinding = (JdbcParameterBinding)entry.getValue();
                if (appliedBinding == null && (parameter == this.offsetParameter ? queryOptions.getLimit() == null || queryOptions.getLimit().getFirstRowJpa() == 0 : (parameter == this.limitParameter ? queryOptions.getLimit() == null || queryOptions.getLimit().getMaxRowsJpa() == Integer.MAX_VALUE : jdbcParameterBindings.getBinding(parameter) == null))) {
                    return false;
                }
                if (parameter == this.offsetParameter || parameter == this.limitParameter || (binding = jdbcParameterBindings.getBinding(parameter)) != null && appliedBinding.getBindType().getJavaTypeDescriptor().areEqual(binding.getBindValue(), appliedBinding.getBindValue())) continue;
                return false;
            }
        }
        Limit limit = queryOptions.getLimit();
        if (this.offsetParameter == null && this.limitParameter == null && limit != null && !limit.isEmpty()) {
            return false;
        }
        if (!this.isCompatible(this.offsetParameter, limit == null ? null : limit.getFirstRow(), 0)) {
            return false;
        }
        return this.isCompatible(this.limitParameter, limit == null ? null : limit.getMaxRows(), Integer.MAX_VALUE);
    }

    private boolean isCompatible(JdbcParameter parameter, Integer requestedValue, int defaultValue) {
        JdbcParameterBinding jdbcParameterBinding;
        int value = requestedValue == null ? defaultValue : requestedValue;
        return !(parameter != null ? (jdbcParameterBinding = (JdbcParameterBinding)this.appliedParameters.get(parameter)) != null && value != (Integer)jdbcParameterBinding.getBindValue() : value != defaultValue);
    }
}

