/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class DelayedCollectionInitializer
extends AbstractCollectionInitializer {
    public DelayedCollectionInitializer(NavigablePath fetchedPath, PluralAttributeMapping fetchedMapping, FetchParentAccess parentAccess, DomainResultAssembler<?> collectionKeyResultAssembler) {
        super(fetchedPath, fetchedMapping, parentAccess, collectionKeyResultAssembler);
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContext();
            LoadingCollectionEntry loadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(this.collectionKey);
            if (loadingEntry != null) {
                this.collectionInstance = loadingEntry.getCollectionInstance();
                return;
            }
            PersistentCollection existing = persistenceContext.getCollection(this.collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                return;
            }
            CollectionPersister collectionDescriptor = this.collectionAttributeMapping.getCollectionDescriptor();
            CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
            Object key = this.collectionKey.getKey();
            this.collectionInstance = collectionSemantics.instantiateWrapper(key, collectionDescriptor, session);
            this.parentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, key);
            if (collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY) {
                session.getPersistenceContext().addCollectionHolder(this.collectionInstance);
            }
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    public String toString() {
        return "DelayedCollectionInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.collectionInstance = null;
    }
}

