/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultInitializer;

public class EmbeddableForeignKeyResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T> {
    private final String resultVariable;

    public EmbeddableForeignKeyResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart embeddableValuedModelPart, String resultVariable, DomainResultCreationState creationState) {
        super(embeddableValuedModelPart.getEmbeddableTypeDescriptor(), navigablePath);
        this.resultVariable = resultVariable;
        this.fetches = creationState.visitFetches(this);
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return true;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public Fetch generateFetchableFetch(Fetchable fetchable, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        boolean shouldSelect;
        if (fetchable instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOne = (ToOneAttributeMapping)fetchable;
            shouldSelect = selected && !creationState.isAssociationKeyVisited(toOne.getForeignKeyDescriptor().getAssociationKey()) && !"{fk}".equals(this.getNavigablePath().getLocalName());
        } else {
            shouldSelect = selected;
        }
        return fetchable.generateFetch(this, fetchablePath, fetchTiming, shouldSelect, resultVariable, creationState);
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(AssemblerCreationState creationState) {
        EmbeddableInitializer initializer = (EmbeddableInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EmbeddableResultInitializer(this, creationState));
        return new EmbeddableAssembler(initializer);
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return (EmbeddableMappingType)this.getFetchContainer().getPartMappingType();
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return super.findFetch(fetchable);
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }
}

