/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.AbstractEntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogger;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BatchEntitySelectFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private static final String CONCRETE_NAME = BatchEntitySelectFetchInitializer.class.getSimpleName();
    private FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler identifierAssembler;
    private final ToOneAttributeMapping referencedModelPart;
    protected Object entityInstance;
    private EntityKey entityKey;
    private Map<EntityKey, Object> toBatchLoad = new LinkedHashMap<EntityKey, Object>();

    public BatchEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler) {
        this.parentAccess = parentAccess;
        this.referencedModelPart = referencedModelPart;
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        Object entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            return;
        }
        this.entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
        this.entityInstance = persistenceContext.getEntity(this.entityKey);
        if (this.entityInstance != null) {
            return;
        }
        Initializer initializer = rowProcessingState.getJdbcValuesSourceProcessingState().findInitializer(this.entityKey);
        if (initializer != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found an initializer for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
            }
            initializer.resolveInstance(rowProcessingState);
            this.entityInstance = initializer.getInitializedInstance();
            return;
        }
        LoadingEntityEntry existingLoadingEntry = rowProcessingState.getSession().getPersistenceContext().getLoadContexts().findLoadingEntityEntry(this.entityKey);
        if (existingLoadingEntry != null && existingLoadingEntry.getEntityInitializer() != this) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            return;
        }
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        this.toBatchLoad.put(this.entityKey, this.parentAccess.getInitializedInstance());
    }

    protected boolean isAttributeAssignableToConcreteDescriptor() {
        AbstractEntityPersister declaringType;
        AbstractEntityPersister concreteDescriptor;
        return !(this.parentAccess instanceof EntityInitializer) || !(concreteDescriptor = (AbstractEntityPersister)((EntityInitializer)this.parentAccess).getConcreteDescriptor()).isPolymorphic() || concreteDescriptor == (declaringType = (AbstractEntityPersister)this.referencedModelPart.getDeclaringType()) || declaringType.getEntityMetamodel().getSubclassEntityNames().contains(concreteDescriptor.getEntityMetamodel().getName());
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.clearResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    public String toString() {
        return "EntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    @Override
    public void endLoading(ExecutionContext context) {
        this.toBatchLoad.forEach((entityKey, parentInstance) -> {
            Object instance = context.getSession().internalLoad(entityKey.getEntityName(), entityKey.getIdentifier(), true, this.referencedModelPart.isNullable());
            if (instance != null) {
                Object[] loadedState;
                ((AbstractEntityPersister)this.referencedModelPart.getDeclaringType()).setPropertyValue(parentInstance, this.referencedModelPart.getPartName(), instance);
                EntityEntry entry = context.getSession().getPersistenceContext().getEntry(parentInstance);
                int propertyIndex = ((UniqueKeyLoadable)((AbstractEntityInitializer)this.parentAccess).getEntityDescriptor()).getPropertyIndex(this.referencedModelPart.getPartName());
                if (entry != null && (loadedState = entry.getLoadedState()) != null) {
                    loadedState[propertyIndex] = instance;
                }
            }
        });
        this.toBatchLoad = null;
        this.parentAccess = null;
    }
}

