/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntitySelectFetchByUniqueKeyInitializer
extends EntitySelectFetchInitializer {
    private final ToOneAttributeMapping fetchedAttribute;

    public EntitySelectFetchByUniqueKeyInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping fetchedAttribute, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler) {
        super(parentAccess, fetchedAttribute, fetchedNavigable, concreteDescriptor, identifierAssembler);
        this.fetchedAttribute = fetchedAttribute;
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        Object entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            return;
        }
        String entityName = this.concreteDescriptor.getEntityName();
        String uniqueKeyPropertyName = this.fetchedAttribute.getReferencedPropertyName();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, entityIdentifier, this.concreteDescriptor.getPropertyType(uniqueKeyPropertyName), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.entityInstance = persistenceContext.getEntity(euk);
        if (this.entityInstance == null) {
            this.entityInstance = ((UniqueKeyLoadable)this.concreteDescriptor).loadByUniqueKey(uniqueKeyPropertyName, entityIdentifier, session);
            if (this.entityInstance != null) {
                persistenceContext.addEntity(euk, this.entityInstance);
            }
        }
        if (this.entityInstance != null) {
            this.entityInstance = persistenceContext.proxyFor(this.entityInstance);
        }
    }
}

