/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.hibernate.query.sqm.sql.internal.InstantiationException;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentReader;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicInstantiationAssemblerConstructorImpl<R>
implements DomainResultAssembler<R> {
    private final Constructor<R> targetConstructor;
    private final JavaType<R> resultType;
    private final List<ArgumentReader<?>> argumentReaders;

    public DynamicInstantiationAssemblerConstructorImpl(Constructor<R> targetConstructor, JavaType<R> resultType, List<ArgumentReader<?>> argumentReaders) {
        this.targetConstructor = targetConstructor;
        this.resultType = resultType;
        this.argumentReaders = argumentReaders;
    }

    @Override
    public JavaType<R> getAssembledJavaTypeDescriptor() {
        return this.resultType;
    }

    @Override
    public R assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        int numberOfArgs = this.argumentReaders.size();
        Object[] args = new Object[numberOfArgs];
        for (int i = 0; i < numberOfArgs; ++i) {
            args[i] = this.argumentReaders.get(i).assemble(rowProcessingState, options);
        }
        try {
            return this.targetConstructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException("Error performing dynamic instantiation : " + this.targetConstructor.getDeclaringClass().getName(), e.getCause());
        }
        catch (Exception e) {
            throw new InstantiationException("Error performing dynamic instantiation : " + this.targetConstructor.getDeclaringClass().getName(), e);
        }
    }
}

