/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.internal.StandardRowReader;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ResultsHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ResultsHelper.class);

    public static <R> RowReader<R> createRowReader(ExecutionContext executionContext, final LockOptions lockOptions, RowTransformer<R> rowTransformer, JdbcValues jdbcValues) {
        final LinkedHashMap initializerMap = new LinkedHashMap();
        final ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        final SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        List<DomainResultAssembler> assemblers = jdbcValues.getValuesMapping().resolveAssemblers(new AssemblerCreationState(){

            @Override
            public LockMode determineEffectiveLockMode(String identificationVariable) {
                return lockOptions.getEffectiveLockMode(identificationVariable);
            }

            @Override
            public Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer> producer) {
                Initializer existing = (Initializer)initializerMap.get(navigablePath);
                if (existing != null && fetchedModelPart.getNavigableRole().equals(existing.getInitializedPart().getNavigableRole())) {
                    ResultsLogger.LOGGER.tracef("Returning previously-registered initializer : %s", existing);
                    return existing;
                }
                Initializer initializer = producer.get();
                ResultsLogger.LOGGER.tracef("Registering initializer : %s", initializer);
                initializerMap.put(navigablePath, initializer);
                initializers.add(initializer);
                return initializer;
            }

            @Override
            public SqlAstCreationContext getSqlAstCreationContext() {
                return sessionFactory;
            }
        });
        return new StandardRowReader<R>(assemblers, initializers, rowTransformer);
    }

    public static void finalizeCollectionLoading(PersistenceContext persistenceContext, CollectionPersister collectionDescriptor, PersistentCollection collectionInstance, Object key, boolean hasNoQueuedAdds) {
        StatisticsImplementor statistics;
        boolean addToCache;
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(collectionInstance);
        if (collectionEntry == null) {
            collectionEntry = persistenceContext.addInitializedCollection(collectionDescriptor, collectionInstance, key);
        } else {
            collectionEntry.postInitialize(collectionInstance);
        }
        if (collectionDescriptor.getCollectionType().hasHolder()) {
            persistenceContext.addCollectionHolder(collectionInstance);
        }
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        batchFetchQueue.removeBatchLoadableCollection(collectionEntry);
        SharedSessionContractImplementor session = persistenceContext.getSession();
        boolean bl = addToCache = hasNoQueuedAdds && collectionDescriptor.hasCache() && session.getCacheMode().isPutEnabled() && !collectionEntry.isDoremove();
        if (addToCache) {
            ResultsHelper.addCollectionToCache(persistenceContext, collectionDescriptor, collectionInstance, key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Collection fully initialized: %s", MessageHelper.collectionInfoString(collectionDescriptor, collectionInstance, key, session));
        }
        if ((statistics = session.getFactory().getStatistics()).isStatisticsEnabled()) {
            statistics.loadCollection(collectionDescriptor.getRole());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCollectionToCache(PersistenceContext persistenceContext, CollectionPersister collectionDescriptor, PersistentCollection collectionInstance, Object key) {
        Object version;
        SharedSessionContractImplementor session = persistenceContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Caching collection: %s", MessageHelper.collectionInfoString(collectionDescriptor, collectionInstance, key, session));
        }
        if (session.getLoadQueryInfluencers().hasEnabledFilters() && collectionDescriptor.isAffectedByEnabledFilters(session)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Refusing to add to cache due to enabled filters");
            }
            return;
        }
        if (collectionDescriptor.isVersioned()) {
            Object collectionOwner = persistenceContext.getCollectionOwner(key, collectionDescriptor);
            if (collectionOwner == null) {
                Object linkedOwner;
                if (collectionInstance != null && (linkedOwner = collectionInstance.getOwner()) != null) {
                    Object ownerKey = collectionDescriptor.getOwnerEntityPersister().getIdentifier(linkedOwner, session);
                    collectionOwner = persistenceContext.getCollectionOwner(ownerKey, collectionDescriptor);
                }
                if (collectionOwner == null) {
                    throw new HibernateException("Unable to resolve owner of loading collection [" + MessageHelper.collectionInfoString(collectionDescriptor, collectionInstance, key, session) + "] for second level caching");
                }
            }
            version = persistenceContext.getEntry(collectionOwner).getVersion();
        } else {
            version = null;
        }
        CollectionCacheEntry entry = new CollectionCacheEntry(collectionInstance, collectionDescriptor);
        CollectionDataAccess cacheAccess = collectionDescriptor.getCacheAccessStrategy();
        Object cacheKey = cacheAccess.generateCacheKey(key, collectionDescriptor, session.getFactory(), session.getTenantIdentifier());
        boolean isPutFromLoad = true;
        if (collectionDescriptor.getElementType().isAssociationType()) {
            EntityPersister entityPersister = ((QueryableCollection)collectionDescriptor).getElementPersister();
            for (Serializable id : entry.getState()) {
                if (!persistenceContext.wasInsertedDuringTransaction(entityPersister, id)) continue;
                isPutFromLoad = false;
                break;
            }
        }
        if (isPutFromLoad) {
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            try {
                eventListenerManager.cachePutStart();
                boolean put = cacheAccess.putFromLoad(session, cacheKey, collectionDescriptor.getCacheEntryStructure().structure(entry), version, factory.getSessionFactoryOptions().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH);
                StatisticsImplementor statistics = factory.getStatistics();
                if (put && statistics.isStatisticsEnabled()) {
                    statistics.collectionCachePut(collectionDescriptor.getNavigableRole(), collectionDescriptor.getCacheAccessStrategy().getRegion().getName());
                }
            }
            finally {
                eventListenerManager.cachePutEnd();
            }
        }
    }
}

