/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;

public final class BasicTypeReference<T>
implements Serializable {
    private final String name;
    private final Class<? extends T> javaType;
    private final int sqlTypeCode;
    private final BasicValueConverter<T, ?> converter;
    private final boolean forceImmutable;

    public BasicTypeReference(String name, Class<? extends T> javaType, int sqlTypeCode) {
        this(name, javaType, sqlTypeCode, null);
    }

    public BasicTypeReference(String name, Class<? extends T> javaType, int sqlTypeCode, BasicValueConverter<T, ?> converter) {
        this(name, javaType, sqlTypeCode, converter, false);
    }

    private BasicTypeReference(String name, Class<? extends T> javaType, int sqlTypeCode, BasicValueConverter<T, ?> converter, boolean forceImmutable) {
        this.name = name;
        this.javaType = javaType;
        this.sqlTypeCode = sqlTypeCode;
        this.converter = converter;
        this.forceImmutable = forceImmutable;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends T> getJavaType() {
        return this.javaType;
    }

    public int getSqlTypeCode() {
        return this.sqlTypeCode;
    }

    public BasicValueConverter<T, ?> getConverter() {
        return this.converter;
    }

    public boolean isForceImmutable() {
        return this.forceImmutable;
    }

    public BasicTypeReference<T> asImmutable() {
        return this.forceImmutable ? this : new BasicTypeReference<T>("imm_" + this.name, this.javaType, this.sqlTypeCode, this.converter, true);
    }
}

