/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.spi.TypeConfiguration;

public class ManyToOneType
extends EntityType {
    private final String propertyName;
    private final boolean ignoreNotFound;
    private boolean isLogicalOneToOne;

    public ManyToOneType(TypeConfiguration typeConfiguration, String referencedEntityName) {
        this(typeConfiguration, referencedEntityName, false);
    }

    public ManyToOneType(TypeConfiguration typeConfiguration, String referencedEntityName, boolean lazy) {
        this(typeConfiguration, referencedEntityName, true, null, null, lazy, true, false, false);
    }

    public ManyToOneType(TypeConfiguration typeConfiguration, String referencedEntityName, boolean referenceToPrimaryKey, String uniqueKeyPropertyName, String propertyName, boolean lazy, boolean unwrapProxy, boolean ignoreNotFound, boolean isLogicalOneToOne) {
        super(typeConfiguration, referencedEntityName, referenceToPrimaryKey, uniqueKeyPropertyName, !lazy, unwrapProxy);
        this.propertyName = propertyName;
        this.ignoreNotFound = ignoreNotFound;
        this.isLogicalOneToOne = isLogicalOneToOne;
    }

    public ManyToOneType(ManyToOneType original, String superTypeEntityName) {
        super(original, superTypeEntityName);
        this.propertyName = original.propertyName;
        this.ignoreNotFound = original.ignoreNotFound;
        this.isLogicalOneToOne = original.isLogicalOneToOne;
    }

    public ManyToOneType(String name, TypeConfiguration typeConfiguration) {
        this(typeConfiguration, name);
    }

    @Override
    public boolean isNullable() {
        return this.ignoreNotFound;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    @Override
    public boolean isOneToOne() {
        return false;
    }

    @Override
    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    @Override
    public int[] getSqlTypeCodes(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).getSqlTypeCodes(mapping);
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).dictatedSizes(mapping);
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).defaultSizes(mapping);
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FROM_PARENT;
    }

    private void scheduleBatchLoadIfNeeded(Object id, SharedSessionContractImplementor session) throws MappingException {
        EntityPersister persister;
        if (this.uniqueKeyPropertyName == null && id != null && (persister = this.getAssociatedEntityPersister(session.getFactory())).isBatchLoadable()) {
            EntityKey entityKey = session.generateEntityKey(id, persister);
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (!persistenceContext.containsEntity(entityKey)) {
                persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
            }
        }
    }

    @Override
    public boolean useLHSPrimaryKey() {
        return false;
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return true;
        }
        assert (current.getClass().isAssignableFrom(old.getClass()));
        return this.getIdentifierOrUniqueKeyType(session.getFactory()).isDirty(this.getIdentifier(old, session), this.getIdentifier(current, session), session);
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object id = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
        return this.getIdentifierType(session).disassemble(id, session, owner);
    }

    @Override
    public Object assemble(Serializable oid, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        Object id = this.assembleId(oid, session);
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }

    private Object assembleId(Serializable oid, SharedSessionContractImplementor session) {
        return this.getIdentifierType(session).assemble(oid, session, null);
    }

    @Override
    public void beforeAssemble(Serializable oid, SharedSessionContractImplementor session) {
        this.scheduleBatchLoadIfNeeded(this.assembleId(oid, session), session);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) throws HibernateException {
        if (this.isSame(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return this.getIdentifierType(session).isDirty(oldid, newid, session);
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        if (this.isAlwaysDirtyChecked()) {
            return this.isDirty(old, current, session);
        }
        if (this.isSame(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return this.getIdentifierType(session).isDirty(oldid, newid, checkable, session);
    }
}

