/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BooleanJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.CharacterJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaType;

@Converter
public class TrueFalseConverter
implements AttributeConverter<Boolean, Character>,
BasicValueConverter<Boolean, Character> {
    public static final TrueFalseConverter INSTANCE = new TrueFalseConverter();

    public Character convertToDatabaseColumn(Boolean attribute) {
        return this.toRelationalValue(attribute);
    }

    public Boolean convertToEntityAttribute(Character dbData) {
        return this.toDomainValue(dbData);
    }

    @Override
    public Boolean toDomainValue(Character relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        switch (relationalForm.charValue()) {
            case 'T': {
                return true;
            }
            case 'F': {
                return false;
            }
        }
        return null;
    }

    @Override
    public Character toRelationalValue(Boolean domainForm) {
        if (domainForm == null) {
            return null;
        }
        return Character.valueOf(domainForm != false ? (char)'T' : 'F');
    }

    @Override
    public JavaType<Boolean> getDomainJavaDescriptor() {
        return BooleanJavaTypeDescriptor.INSTANCE;
    }

    @Override
    public JavaType<Character> getRelationalJavaDescriptor() {
        return CharacterJavaTypeDescriptor.INSTANCE;
    }
}

