/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.util.Comparator;
import org.hibernate.type.descriptor.java.AbstractClassJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractTemporalJavaTypeDescriptor<T>
extends AbstractClassJavaTypeDescriptor<T>
implements TemporalJavaTypeDescriptor<T> {
    protected AbstractTemporalJavaTypeDescriptor(Class<? extends T> type) {
        super(type);
    }

    protected AbstractTemporalJavaTypeDescriptor(Class<? extends T> type, MutabilityPlan<? extends T> mutabilityPlan) {
        super(type, mutabilityPlan);
    }

    public AbstractTemporalJavaTypeDescriptor(Class<? extends T> type, MutabilityPlan<? extends T> mutabilityPlan, Comparator<? extends T> comparator) {
        super(type, mutabilityPlan, comparator);
    }

    @Override
    public final <X> TemporalJavaTypeDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration typeConfiguration) {
        if (precision == null) {
            return this.forMissingPrecision(typeConfiguration);
        }
        switch (precision) {
            case DATE: {
                return this.forDatePrecision(typeConfiguration);
            }
            case TIME: {
                return this.forTimePrecision(typeConfiguration);
            }
            case TIMESTAMP: {
                return this.forTimestampPrecision(typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }

    private <X> TemporalJavaTypeDescriptor<X> forMissingPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(this + " as `jakarta.persistence.TemporalType.TIMESTAMP` not supported");
    }

    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(this + " as `jakarta.persistence.TemporalType.DATE` not supported");
    }

    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(this + " as `jakarta.persistence.TemporalType.TIME` not supported");
    }

    public String toString() {
        return "TemporalJavaTypeDescriptor(javaType=" + ((Class)this.getJavaType()).getTypeName() + ")";
    }
}

