/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BooleanJavaTypeDescriptor
extends AbstractClassJavaTypeDescriptor<Boolean>
implements PrimitiveJavaType<Boolean> {
    public static final BooleanJavaTypeDescriptor INSTANCE = new BooleanJavaTypeDescriptor();
    private final char characterValueTrue;
    private final char characterValueFalse;
    private final char characterValueTrueLC;
    private final String stringValueTrue;
    private final String stringValueFalse;

    public BooleanJavaTypeDescriptor() {
        this('Y', 'N');
    }

    public BooleanJavaTypeDescriptor(char characterValueTrue, char characterValueFalse) {
        super(Boolean.class);
        this.characterValueTrue = Character.toUpperCase(characterValueTrue);
        this.characterValueFalse = Character.toUpperCase(characterValueFalse);
        this.characterValueTrueLC = Character.toLowerCase(characterValueTrue);
        this.stringValueTrue = String.valueOf(characterValueTrue);
        this.stringValueFalse = String.valueOf(characterValueFalse);
    }

    @Override
    public String toString(Boolean value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Boolean fromString(CharSequence string) {
        return Boolean.valueOf(string.toString());
    }

    @Override
    public <X> X unwrap(Boolean value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)this.toByte(value);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)this.toShort(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)this.toInteger(value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)this.toLong(value);
        }
        if (Character.class.isAssignableFrom(type)) {
            return (X)Character.valueOf(value != false ? this.characterValueTrue : this.characterValueFalse);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)(value != false ? this.stringValueTrue : this.stringValueFalse);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Boolean wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isInstance(value)) {
            return (Boolean)value;
        }
        if (Number.class.isInstance(value)) {
            int intValue = ((Number)value).intValue();
            return intValue != 0;
        }
        if (Character.class.isInstance(value)) {
            return this.isTrue(((Character)value).charValue());
        }
        if (String.class.isInstance(value)) {
            return this.isTrue((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    private boolean isTrue(String strValue) {
        if (strValue != null && !strValue.isEmpty()) {
            return this.isTrue(strValue.charAt(0));
        }
        return false;
    }

    private boolean isTrue(char charValue) {
        return charValue == this.characterValueTrue || charValue == this.characterValueTrueLC;
    }

    public int toInt(Boolean value) {
        return value != false ? 1 : 0;
    }

    public Byte toByte(Boolean value) {
        return (byte)this.toInt(value);
    }

    public Short toShort(Boolean value) {
        return (short)this.toInt(value);
    }

    public Integer toInteger(Boolean value) {
        return this.toInt(value);
    }

    public Long toLong(Boolean value) {
        return this.toInt(value);
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Class<Boolean[]> getArrayClass() {
        return Boolean[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return boolean[].class;
    }

    @Override
    public Boolean getDefaultValue() {
        return false;
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 1L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 1;
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType sqlTypeDescriptor, Dialect dialect) {
        return dialect.getBooleanCheckCondition(columnName, sqlTypeDescriptor.getJdbcTypeCode(), this.characterValueFalse, this.characterValueTrue);
    }
}

