/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Currency;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaTypeDescriptor;

public class CurrencyJavaTypeDescriptor
extends AbstractClassJavaTypeDescriptor<Currency> {
    public static final CurrencyJavaTypeDescriptor INSTANCE = new CurrencyJavaTypeDescriptor();

    public CurrencyJavaTypeDescriptor() {
        super(Currency.class);
    }

    @Override
    public String toString(Currency value) {
        return value.getCurrencyCode();
    }

    @Override
    public Currency fromString(CharSequence string) {
        return Currency.getInstance(string.toString());
    }

    @Override
    public <X> X unwrap(Currency value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.getCurrencyCode();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Currency wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return Currency.getInstance((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

