/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcTimeJavaTypeDescriptor
extends AbstractTemporalJavaTypeDescriptor<java.util.Date> {
    public static final JdbcTimeJavaTypeDescriptor INSTANCE = new JdbcTimeJavaTypeDescriptor();
    public static final String TIME_FORMAT = "HH:mm:ss.SSS";
    public static final DateTimeFormatter LITERAL_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final DateTimeFormatter LOGGABLE_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;

    public JdbcTimeJavaTypeDescriptor() {
        super(Time.class, TimeMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof java.util.Date && !(value instanceof Date);
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(11);
        hashCode = 31 * hashCode + calendar.get(12);
        hashCode = 31 * hashCode + calendar.get(13);
        hashCode = 31 * hashCode + calendar.get(14);
        return hashCode;
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one.getTime() == another.getTime()) {
            return true;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(one);
        calendar2.setTime(another);
        return calendar1.get(11) == calendar2.get(11) && calendar1.get(12) == calendar2.get(12) && calendar1.get(13) == calendar2.get(13) && calendar1.get(14) == calendar2.get(14);
    }

    @Override
    public java.util.Date coerce(Object value, JavaType.CoercionContext coercionContext) {
        return this.wrap(value, (WrapperOptions)null);
    }

    @Override
    public Object unwrap(java.util.Date value, Class type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            return value instanceof Time ? ((Time)value).toLocalTime() : new Time(value.getTime()).toLocalTime();
        }
        if (Time.class.isAssignableFrom(type)) {
            return value instanceof Time ? value : new Time(value.getTime());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return value;
        }
        if (Long.class.isAssignableFrom(type)) {
            return value.getTime();
        }
        if (String.class.isAssignableFrom(type)) {
            return this.toString(value);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return cal;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return new Timestamp(value.getTime());
        }
        if (Date.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Illegal attempt to treat `java.sql.Time` as `java.sql.Date`");
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public java.util.Date wrap(Object value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalTime) {
            return Time.valueOf((LocalTime)value);
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Long) {
            return new Time((Long)value);
        }
        if (value instanceof Calendar) {
            return new Time(((Calendar)value).getTimeInMillis());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public String toString(java.util.Date value) {
        return new SimpleDateFormat(TIME_FORMAT).format(value);
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            return new Time(new SimpleDateFormat(TIME_FORMAT).parse(string.toString()).getTime());
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse time string" + string, pe);
        }
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeDescriptorRegistry().getDescriptor(92);
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    public static class TimeMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final TimeMutabilityPlan INSTANCE = new TimeMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return new Time(value.getTime());
        }
    }
}

