/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class BlobJdbcType
implements JdbcType {
    public static final BlobJdbcType DEFAULT = new BlobJdbcType(){

        @Override
        public String toString() {
            return "BlobTypeDescriptor(DEFAULT)";
        }

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    BlobJdbcType descriptor = BLOB_BINDING;
                    if (byte[].class.isInstance(value)) {
                        descriptor = PRIMITIVE_ARRAY_BINDING;
                    } else if (options.useStreamForLobBinding()) {
                        descriptor = STREAM_BINDING;
                    }
                    descriptor.getBlobBinder(javaTypeDescriptor).doBind(st, value, index, options);
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    BlobJdbcType descriptor = BLOB_BINDING;
                    if (byte[].class.isInstance(value)) {
                        descriptor = PRIMITIVE_ARRAY_BINDING;
                    } else if (options.useStreamForLobBinding()) {
                        descriptor = STREAM_BINDING;
                    }
                    descriptor.getBlobBinder(javaTypeDescriptor).doBind(st, value, name, options);
                }
            };
        }
    };
    public static final BlobJdbcType PRIMITIVE_ARRAY_BINDING = new BlobJdbcType(){

        @Override
        public String toString() {
            return "BlobTypeDescriptor(PRIMITIVE_ARRAY_BINDING)";
        }

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                public void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setBytes(index, javaTypeDescriptor.unwrap(value, byte[].class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setBytes(name, javaTypeDescriptor.unwrap(value, byte[].class, options));
                }
            };
        }
    };
    public static final BlobJdbcType BLOB_BINDING = new BlobJdbcType(){

        @Override
        public String toString() {
            return "BlobTypeDescriptor(BLOB_BINDING)";
        }

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setBlob(index, javaTypeDescriptor.unwrap(value, Blob.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setBlob(name, javaTypeDescriptor.unwrap(value, Blob.class, options));
                }
            };
        }
    };
    public static final BlobJdbcType STREAM_BINDING = new BlobJdbcType(){

        @Override
        public String toString() {
            return "BlobTypeDescriptor(STREAM_BINDING)";
        }

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(value, BinaryStream.class, options);
                    st.setBinaryStream(index, binaryStream.getInputStream(), binaryStream.getLength());
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(value, BinaryStream.class, options);
                    st.setBinaryStream(name, binaryStream.getInputStream(), binaryStream.getLength());
                }
            };
        }
    };

    private BlobJdbcType() {
    }

    @Override
    public int getJdbcTypeCode() {
        return 2004;
    }

    @Override
    public String getFriendlyName() {
        return "BLOB";
    }

    public String toString() {
        return "BlobTypeDescriptor";
    }

    @Override
    public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return (BasicJavaType)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Blob.class));
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getBlob(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getBlob(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getBlob(name), options);
            }
        };
    }

    protected abstract <X> BasicBinder<X> getBlobBinder(JavaType<X> var1);

    public <X> BasicBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return this.getBlobBinder(javaTypeDescriptor);
    }
}

