/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;

public class ObjectJdbcType
implements JdbcType {
    public static final ObjectJdbcType INSTANCE = new ObjectJdbcType(2000);
    private final int jdbcTypeCode;

    public ObjectJdbcType(int jdbcTypeCode) {
        this.jdbcTypeCode = jdbcTypeCode;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    public String toString() {
        return "ObjectSqlTypeDescriptor(" + this.jdbcTypeCode + ")";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
            return VarbinaryJdbcType.INSTANCE.getBinder(javaTypeDescriptor);
        }
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, value, ObjectJdbcType.this.jdbcTypeCode);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, value, ObjectJdbcType.this.jdbcTypeCode);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
            return VarbinaryJdbcType.INSTANCE.getExtractor(javaTypeDescriptor);
        }
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return rs.getObject(paramIndex);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return statement.getObject(index);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return statement.getObject(name);
            }
        };
    }
}

