/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;

public class ObjectNullAsBinaryTypeJdbcType
extends ObjectJdbcType {
    public static final ObjectNullAsBinaryTypeJdbcType INSTANCE = new ObjectNullAsBinaryTypeJdbcType(2000);

    public ObjectNullAsBinaryTypeJdbcType(int jdbcTypeCode) {
        super(jdbcTypeCode);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
            return VarbinaryJdbcType.INSTANCE.getBinder(javaTypeDescriptor);
        }
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, -3);
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, -3);
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, value, ObjectNullAsBinaryTypeJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, value, ObjectNullAsBinaryTypeJdbcType.this.getJdbcTypeCode());
            }
        };
    }
}

