/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.internal.PersistentMap;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.collection.internal.PersistentSortedMap;
import org.hibernate.collection.internal.PersistentSortedSet;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class Hibernate {
    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(Object proxy) throws HibernateException {
        PersistentAttributeInterceptable interceptable;
        PersistentAttributeInterceptor interceptor;
        if (proxy == null) {
            return;
        }
        if (proxy instanceof HibernateProxy) {
            ((HibernateProxy)proxy).getHibernateLazyInitializer().initialize();
        } else if (proxy instanceof PersistentCollection) {
            ((PersistentCollection)proxy).forceInitialization();
        } else if (proxy instanceof PersistentAttributeInterceptable && (interceptor = (interceptable = (PersistentAttributeInterceptable)proxy).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            ((EnhancementAsProxyLazinessInterceptor)interceptor).forceInitialize(proxy, null);
        }
    }

    public static boolean isInitialized(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return !((HibernateProxy)proxy).getHibernateLazyInitializer().isUninitialized();
        }
        if (proxy instanceof PersistentAttributeInterceptable) {
            PersistentAttributeInterceptor interceptor = ((PersistentAttributeInterceptable)proxy).$$_hibernate_getInterceptor();
            return !(interceptor instanceof EnhancementAsProxyLazinessInterceptor);
        }
        if (proxy instanceof PersistentCollection) {
            return ((PersistentCollection)proxy).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return ((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return proxy.getClass();
    }

    public static LobCreator getLobCreator(Session session) {
        return Hibernate.getLobCreator((SessionImplementor)session);
    }

    public static LobCreator getLobCreator(SharedSessionContractImplementor session) {
        return session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
    }

    public static LobCreator getLobCreator(SessionImplementor session) {
        return session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
    }

    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object proxy, String propertyName) {
        PersistentAttributeInterceptor interceptor;
        Object entity;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return false;
            }
            entity = li.getImplementation();
        } else {
            entity = proxy;
        }
        if (entity instanceof PersistentAttributeInterceptable && (interceptor = ((PersistentAttributeInterceptable)entity).$$_hibernate_getInterceptor()) instanceof BytecodeLazyAttributeInterceptor) {
            return ((BytecodeLazyAttributeInterceptor)interceptor).isAttributeLoaded(propertyName);
        }
        return true;
    }

    public static Object unproxy(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)proxy;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            return initializer.getImplementation();
        }
        return proxy;
    }

    public static <T> T unproxy(T proxy, Class<T> entityClass) {
        return entityClass.cast(Hibernate.unproxy(proxy));
    }

    public static <E> E createDetachedProxy(SessionFactory sessionFactory, Class<E> entityClass, Object id) {
        EntityPersister persister = ((SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class)).getMetamodel().findEntityDescriptor(entityClass);
        if (persister == null) {
            throw new UnknownEntityTypeException("unknown entity type");
        }
        return (E)persister.createProxy(id, null);
    }

    public static <U> CollectionInterface<Collection<U>> bag() {
        return new CollectionInterface<Collection<U>>(PersistentBag::new, ArrayList::new);
    }

    public static <U> CollectionInterface<Set<U>> set() {
        return new CollectionInterface<Set<U>>(PersistentSet::new, HashSet::new);
    }

    public static <U> CollectionInterface<List<U>> list() {
        return new CollectionInterface<List<U>>(PersistentList::new, ArrayList::new);
    }

    public static <U, V> CollectionInterface<Map<U, V>> map() {
        return new CollectionInterface<Map<U, V>>(PersistentMap::new, HashMap::new);
    }

    public static <U> CollectionInterface<SortedSet<U>> sortedSet() {
        return new CollectionInterface<SortedSet<U>>(PersistentSortedSet::new, TreeSet::new);
    }

    public static <U, V> CollectionInterface<Map<U, V>> sortedMap() {
        return new CollectionInterface<Map<U, V>>(PersistentSortedMap::new, TreeMap::new);
    }

    public static <C> CollectionInterface<C> collection(Class<C> collectionClass) {
        if (collectionClass == List.class) {
            return Hibernate.list();
        }
        if (collectionClass == Set.class) {
            return Hibernate.set();
        }
        if (collectionClass == Map.class) {
            return Hibernate.map();
        }
        if (collectionClass == SortedMap.class) {
            return Hibernate.sortedMap();
        }
        if (collectionClass == SortedSet.class) {
            return Hibernate.sortedSet();
        }
        if (collectionClass == Collection.class) {
            return Hibernate.bag();
        }
        throw new IllegalArgumentException("illegal collection interface type");
    }

    public static final class CollectionInterface<C> {
        private final Supplier<C> detached;
        private final Supplier<C> created;

        private CollectionInterface(Supplier<C> detached, Supplier<C> created) {
            this.detached = detached;
            this.created = created;
        }

        public C createDetachedInstance() {
            return this.detached.get();
        }

        public C createNewInstance() {
            return this.created.get();
        }
    }
}

