/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.boot.model.process.internal.UserTypeResolution;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.UserType;

public class TypeDefinition
implements Serializable {
    public static final AtomicInteger NAME_COUNTER = new AtomicInteger();
    private final String name;
    private final Class typeImplementorClass;
    private final String[] registrationKeys;
    private final Properties parameters;
    private BasicValue.Resolution<?> reusableResolution;

    public TypeDefinition(String name, Class typeImplementorClass, String[] registrationKeys, Properties parameters, TypeConfiguration typeConfiguration) {
        this.name = name;
        this.typeImplementorClass = typeImplementorClass;
        this.registrationKeys = registrationKeys;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public Class getTypeImplementorClass() {
        return this.typeImplementorClass;
    }

    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public BasicValue.Resolution<?> resolve(Map localConfigParameters, MutabilityPlan explicitMutabilityPlan, MetadataBuildingContext context, JdbcTypeDescriptorIndicators indicators) {
        if (CollectionHelper.isEmpty(localConfigParameters)) {
            if (this.reusableResolution == null) {
                this.reusableResolution = this.createResolution(this.name, Collections.emptyMap(), indicators, context);
            }
            return this.reusableResolution;
        }
        String name = this.name + ":" + NAME_COUNTER.getAndIncrement();
        return this.createResolution(name, localConfigParameters, indicators, context);
    }

    private BasicValue.Resolution<?> createResolution(String name, Map<?, ?> usageSiteProperties, JdbcTypeDescriptorIndicators indicators, MetadataBuildingContext context) {
        return TypeDefinition.createResolution(name, this.typeImplementorClass, this.parameters, usageSiteProperties, indicators, context);
    }

    private static BasicValue.Resolution<?> createResolution(String name, Class<?> typeImplementorClass, Properties parameters, Map<?, ?> usageSiteProperties, JdbcTypeDescriptorIndicators indicators, MetadataBuildingContext context) {
        boolean isKnownType;
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        BeanInstanceProducer instanceProducer = bootstrapContext.getBeanInstanceProducer();
        boolean bl = isKnownType = Type.class.isAssignableFrom(typeImplementorClass) || UserType.class.isAssignableFrom(typeImplementorClass);
        if (isKnownType) {
            Properties combinedTypeParameters;
            ManagedBean<?> typeBean = name != null ? bootstrapContext.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(name, typeImplementorClass, instanceProducer) : bootstrapContext.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(typeImplementorClass, instanceProducer);
            Object typeInstance = typeBean.getBeanInstance();
            if (typeInstance instanceof TypeConfigurationAware) {
                ((TypeConfigurationAware)typeInstance).setTypeConfiguration(typeConfiguration);
            }
            if (CollectionHelper.isNotEmpty(usageSiteProperties)) {
                combinedTypeParameters = new Properties(parameters);
                combinedTypeParameters.putAll(usageSiteProperties);
            } else {
                combinedTypeParameters = parameters;
            }
            MappingHelper.injectParameters(typeInstance, combinedTypeParameters);
            if (typeInstance instanceof UserType) {
                UserType userType = (UserType)typeInstance;
                CustomType<Object> customType = new CustomType<Object>(userType, typeConfiguration);
                return new UserTypeResolution(customType, null, combinedTypeParameters);
            }
            if (typeInstance instanceof BasicType) {
                final BasicType resolvedBasicType = (BasicType)typeInstance;
                return new BasicValue.Resolution<Object>(){

                    @Override
                    public JdbcMapping getJdbcMapping() {
                        return resolvedBasicType;
                    }

                    @Override
                    public BasicType getLegacyResolvedBasicType() {
                        return resolvedBasicType;
                    }

                    @Override
                    public Properties getCombinedTypeParameters() {
                        return combinedTypeParameters;
                    }

                    @Override
                    public JavaType<Object> getDomainJavaDescriptor() {
                        return resolvedBasicType.getMappedJavaTypeDescriptor();
                    }

                    @Override
                    public JavaType<?> getRelationalJavaDescriptor() {
                        return resolvedBasicType.getMappedJavaTypeDescriptor();
                    }

                    @Override
                    public JdbcType getJdbcTypeDescriptor() {
                        return resolvedBasicType.getJdbcTypeDescriptor();
                    }

                    @Override
                    public BasicValueConverter getValueConverter() {
                        return null;
                    }

                    @Override
                    public MutabilityPlan<Object> getMutabilityPlan() {
                        return resolvedBasicType.isMutable() ? this.getDomainJavaDescriptor().getMutabilityPlan() : ImmutableMutabilityPlan.instance();
                    }
                };
            }
        }
        if (Serializable.class.isAssignableFrom(typeImplementorClass)) {
            JavaType jtd = typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(typeImplementorClass);
            JdbcType jdbcType = typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(-3);
            final BasicType resolved = typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
            final SerializableType legacyType = new SerializableType(typeImplementorClass);
            return new BasicValue.Resolution<Object>(){

                @Override
                public JdbcMapping getJdbcMapping() {
                    return resolved;
                }

                @Override
                public BasicType getLegacyResolvedBasicType() {
                    return legacyType;
                }

                @Override
                public JavaType<Object> getDomainJavaDescriptor() {
                    return resolved.getMappedJavaTypeDescriptor();
                }

                @Override
                public JavaType<?> getRelationalJavaDescriptor() {
                    return resolved.getMappedJavaTypeDescriptor();
                }

                @Override
                public JdbcType getJdbcTypeDescriptor() {
                    return resolved.getJdbcTypeDescriptor();
                }

                @Override
                public BasicValueConverter getValueConverter() {
                    return null;
                }

                @Override
                public MutabilityPlan<Object> getMutabilityPlan() {
                    return resolved.isMutable() ? this.getDomainJavaDescriptor().getMutabilityPlan() : ImmutableMutabilityPlan.instance();
                }
            };
        }
        throw new IllegalArgumentException("Named type [" + typeImplementorClass + "] did not implement BasicType nor UserType");
    }

    public static BasicValue.Resolution<?> createLocalResolution(String name, Class typeImplementorClass, MutabilityPlan explicitMutabilityPlan, Map localTypeParams, MetadataBuildingContext buildingContext) {
        name = (String)name + ":" + NAME_COUNTER.getAndIncrement();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)localTypeParams);
        TypeConfiguration typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        return TypeDefinition.createResolution((String)name, typeImplementorClass, properties, null, typeConfiguration.getCurrentBaseSqlTypeIndicators(), buildingContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.typeImplementorClass, that.typeImplementorClass) && Arrays.equals(this.registrationKeys, that.registrationKeys) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.typeImplementorClass != null ? this.typeImplementorClass.hashCode() : 0);
        result = 31 * result + (this.registrationKeys != null ? Arrays.hashCode(this.registrationKeys) : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeDefinition{name='" + this.name + "', typeImplementorClass=" + this.typeImplementorClass + ", registrationKeys=" + Arrays.toString(this.registrationKeys) + ", parameters=" + this.parameters + "}";
    }
}

