/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterResolution<J>
implements BasicValue.Resolution<J> {
    private final JavaType domainJtd;
    private final JavaType relationalJtd;
    private final JdbcType jdbcType;
    private final JpaAttributeConverter valueConverter;
    private final MutabilityPlan mutabilityPlan;
    private final JdbcMapping jdbcMapping;
    private final BasicType legacyResolvedType;

    public static NamedConverterResolution from(ConverterDescriptor converterDescriptor, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JdbcTypeDescriptorIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, converterDescriptor.createJpaAttributeConverter(converterCreationContext), sqlTypeIndicators, context);
    }

    public static NamedConverterResolution from(String name, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JdbcTypeDescriptorIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        assert (name.startsWith("converted::"));
        String converterClassName = name.substring("converted::".length());
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        Class converterClass = classLoaderService.classForName(converterClassName);
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(converterClass, context.getBootstrapContext().getClassmateContext());
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, converterDescriptor.createJpaAttributeConverter(converterCreationContext), sqlTypeIndicators, context);
    }

    private static NamedConverterResolution fromInternal(Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JpaAttributeConverter converter, JdbcTypeDescriptorIndicators sqlTypeIndicators, MetadataBuildingContext context) {
        AttributeConverterMutabilityPlanImpl explicitMutabilityPlan;
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType explicitJtd = explicitJtdAccess != null ? (JavaType)explicitJtdAccess.apply(typeConfiguration) : null;
        JavaType domainJtd = explicitJtd != null ? explicitJtd : converter.getDomainJavaDescriptor();
        JdbcType explicitJdbcType = explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null;
        JavaType relationalJtd = converter.getRelationalJavaDescriptor();
        JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(sqlTypeIndicators);
        AttributeConverterMutabilityPlanImpl attributeConverterMutabilityPlanImpl = explicitMutabilityPlan = explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null;
        MutabilityPlan mutabilityPlan = explicitMutabilityPlan != null ? explicitMutabilityPlan : (!domainJtd.getMutabilityPlan().isMutable() ? ImmutableMutabilityPlan.INSTANCE : new AttributeConverterMutabilityPlanImpl(converter, true));
        return new NamedConverterResolution(domainJtd, relationalJtd, jdbcType, converter, mutabilityPlan, context.getBootstrapContext().getTypeConfiguration());
    }

    public NamedConverterResolution(JavaType domainJtd, JavaType relationalJtd, JdbcType jdbcType, JpaAttributeConverter valueConverter, MutabilityPlan mutabilityPlan, TypeConfiguration typeConfiguration) {
        assert (domainJtd != null);
        this.domainJtd = domainJtd;
        assert (relationalJtd != null);
        this.relationalJtd = relationalJtd;
        assert (jdbcType != null);
        this.jdbcType = jdbcType;
        assert (valueConverter != null);
        this.valueConverter = valueConverter;
        assert (mutabilityPlan != null);
        this.mutabilityPlan = mutabilityPlan;
        this.jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcType);
        this.legacyResolvedType = new AttributeConverterTypeAdapter("converted::" + valueConverter.getConverterJavaTypeDescriptor().getJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getJavaType().getTypeName(), relationalJtd.getJavaType().getTypeName()), valueConverter, jdbcType, relationalJtd, domainJtd, mutabilityPlan);
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.legacyResolvedType;
    }

    @Override
    public JavaType<J> getDomainJavaDescriptor() {
        return this.domainJtd;
    }

    @Override
    public JavaType<?> getRelationalJavaDescriptor() {
        return this.relationalJtd;
    }

    @Override
    public JdbcType getJdbcTypeDescriptor() {
        return this.jdbcType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JpaAttributeConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return "NamedConverterResolution(" + this.valueConverter.getConverterBean().getBeanClass().getName() + ")";
    }
}

