/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.AttributeConverterInfo;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.internal.InstanceBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.GenericsHelper;

@Deprecated
public class AttributeConverterDefinition
implements AttributeConverterInfo {
    private final AttributeConverter attributeConverter;
    private final boolean autoApply;
    private final Class entityAttributeType;
    private final Class databaseColumnType;

    public static AttributeConverterDefinition from(Class<? extends AttributeConverter> attributeConverterClass, boolean autoApply) {
        return new AttributeConverterDefinition(AttributeConverterDefinition.instantiateAttributeConverter(attributeConverterClass), autoApply);
    }

    private static AttributeConverter instantiateAttributeConverter(Class<? extends AttributeConverter> attributeConverterClass) {
        try {
            Constructor<? extends AttributeConverter> constructor = attributeConverterClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to instantiate AttributeConverter [" + attributeConverterClass.getName() + "]", e);
        }
    }

    public static AttributeConverterDefinition from(Class<? extends AttributeConverter> attributeConverterClass) {
        return AttributeConverterDefinition.from(AttributeConverterDefinition.instantiateAttributeConverter(attributeConverterClass));
    }

    public static AttributeConverterDefinition from(AttributeConverter attributeConverter) {
        boolean autoApply = false;
        Converter converterAnnotation = attributeConverter.getClass().getAnnotation(Converter.class);
        if (converterAnnotation != null) {
            autoApply = converterAnnotation.autoApply();
        }
        return new AttributeConverterDefinition(attributeConverter, autoApply);
    }

    public static AttributeConverterDefinition from(AttributeConverter attributeConverter, boolean autoApply) {
        return new AttributeConverterDefinition(attributeConverter, autoApply);
    }

    public AttributeConverterDefinition(AttributeConverter attributeConverter, boolean autoApply) {
        this.attributeConverter = attributeConverter;
        this.autoApply = autoApply;
        Class<?> attributeConverterClass = attributeConverter.getClass();
        ParameterizedType attributeConverterSignature = ConverterHelper.extractAttributeConverterParameterizedType(attributeConverterClass);
        if (attributeConverterSignature == null) {
            throw new AssertionFailure("Could not extract ParameterizedType representation of AttributeConverter definition from AttributeConverter implementation class [" + attributeConverterClass.getName() + "]");
        }
        if (attributeConverterSignature.getActualTypeArguments().length < 2) {
            throw new AnnotationException("AttributeConverter [" + attributeConverterClass.getName() + "] did not retain parameterized type information");
        }
        if (attributeConverterSignature.getActualTypeArguments().length > 2) {
            throw new AnnotationException("AttributeConverter [" + attributeConverterClass.getName() + "] specified more than 2 parameterized types");
        }
        this.entityAttributeType = GenericsHelper.extractClass(attributeConverterSignature.getActualTypeArguments()[0]);
        if (this.entityAttributeType == null) {
            throw new AnnotationException("Could not determine 'entity attribute' type from given AttributeConverter [" + attributeConverterClass.getName() + "]");
        }
        this.databaseColumnType = GenericsHelper.extractClass(attributeConverterSignature.getActualTypeArguments()[1]);
        if (this.databaseColumnType == null) {
            throw new AnnotationException("Could not determine 'database column' type from given AttributeConverter [" + attributeConverterClass.getName() + "]");
        }
    }

    public AttributeConverter getAttributeConverter() {
        return this.attributeConverter;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public Class getEntityAttributeType() {
        return this.entityAttributeType;
    }

    public Class getDatabaseColumnType() {
        return this.databaseColumnType;
    }

    @Override
    public Class<? extends AttributeConverter> getConverterClass() {
        return this.attributeConverter.getClass();
    }

    public String toString() {
        return String.format("%s[converterClass=%s, domainType=%s, jdbcType=%s]", this.getClass().getName(), this.attributeConverter.getClass().getName(), this.entityAttributeType.getName(), this.databaseColumnType.getName());
    }

    @Override
    public ConverterDescriptor toConverterDescriptor(MetadataBuildingContext context) {
        return new InstanceBasedConverterDescriptor(this.getAttributeConverter(), (Boolean)this.isAutoApply(), context.getBootstrapContext().getClassmateContext());
    }
}

