/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.DerbySqlAstTranslator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.DerbyLpadEmulation;
import org.hibernate.dialect.function.DerbyRpadEmulation;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.DerbyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DerbySequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.CastType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDerbyDatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.BigDecimalJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class DerbyDialect
extends Dialect {
    private final LimitHandler limitHandler = this.getVersion().isBefore(10, 5) ? AbstractLimitHandler.NO_LIMIT : new DerbyLimitHandler(this.getVersion().isSameOrAfter(10, 6));

    public DerbyDialect() {
        this(DatabaseVersion.make(10, 0));
    }

    public DerbyDialect(DatabaseVersion version) {
        super(version);
        this.registerDerbyKeywords();
    }

    public DerbyDialect(DialectResolutionInfo info) {
        super(info);
        this.registerDerbyKeywords();
    }

    @Override
    protected String columnType(int jdbcTypeCode) {
        if (jdbcTypeCode == 16 && this.getVersion().isBefore(10, 7)) {
            return "smallint";
        }
        switch (jdbcTypeCode) {
            case -6: {
                return "smallint";
            }
            case 2: {
                return super.columnType(3);
            }
            case -3: {
                return "varchar($l) for bit data";
            }
            case 2004: {
                return "blob($l)";
            }
            case 2005: {
                return "clob($l)";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
        }
        return super.columnType(jdbcTypeCode);
    }

    @Override
    protected void registerDefaultColumnTypes() {
        super.registerDefaultColumnTypes();
        int maxLongVarcharLength = 32700;
        this.registerColumnType(-3, maxLongVarcharLength, "long varchar for bit data");
        this.registerColumnType(12, maxLongVarcharLength, "long varchar");
        this.registerColumnType(-2, 254L, "char($l) for bit data");
        this.registerColumnType(-2, this.getMaxVarcharLength(), "varchar($l) for bit data");
        this.registerColumnType(-2, maxLongVarcharLength, "long varchar for bit data");
    }

    @Override
    public int getMaxVarcharLength() {
        return 32672;
    }

    @Override
    public String getTypeName(int code, Size size) throws HibernateException {
        if (code == 1 && size.getLength() > 254L) {
            return "char(254)";
        }
        return super.getTypeName(code, size);
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion().isBefore(10, 7) ? 5 : 16;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public int getDoublePrecision() {
        return 52;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        BasicTypeRegistry basicTypeRegistry = queryEngine.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<String> stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        CommonFunctionFactory.aggregates(this, queryEngine, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, "||", this.getCastTypeName(stringType, null, null, null));
        CommonFunctionFactory.avg_castingNonDoubleArguments(this, queryEngine, SqlAstNodeRenderingMode.DEFAULT);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.trim1(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.leftRight_substrLength(queryEngine);
        CommonFunctionFactory.characterLength_length(queryEngine, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        CommonFunctionFactory.power_expLn(queryEngine);
        CommonFunctionFactory.bitLength_pattern(queryEngine, "length(?1)*8");
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("round", "floor(?1*1e?2+0.5)/1e?2").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().register("concat", new CastingConcatFunction(this, "||", SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("lpad", new DerbyLpadEmulation(queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("rpad", new DerbyRpadEmulation(queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("least", new CaseLeastGreatestEmulation(true));
        queryEngine.getSqmFunctionRegistry().register("greatest", new CaseLeastGreatestEmulation(false));
        queryEngine.getSqmFunctionRegistry().register("overlay", new InsertSubstringOverlayEmulation(queryEngine.getTypeConfiguration(), true));
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DerbySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
            case DAY_OF_YEAR: {
                return "({fn timestampdiff(sql_tsi_day,date(char(year(?2),4)||'-01-01'),?2)}+1)";
            }
            case DAY_OF_WEEK: {
                return "(mod(mod({fn timestampdiff(sql_tsi_day,{d '1970-01-01'},?2)}+4,7)+7,7)+1)";
            }
            case WEEK: {
                return "(({fn timestampdiff(sql_tsi_day,date(char(year(?2),4)||'-01-01'),{fn timestampadd(sql_tsi_day,{fn timestampdiff(sql_tsi_day,{d '1753-01-01'},?2)}/7*7,{d '1753-01-04'})})}+7)/7)";
            }
            case QUARTER: {
                return "((month(?2)+2)/3)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case WEEK: {
                throw new NotYetImplementedFor6Exception("field type not supported on Derby: " + unit);
            }
            case DAY_OF_MONTH: {
                return "day";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case FLOAT: {
                return "cast(double(?1) as real)";
            }
            case DOUBLE: {
                return "double(?1)";
            }
            case STRING: {
                switch (from) {
                    case FLOAT: 
                    case DOUBLE: {
                        return "cast(trim(cast(cast(?1 as decimal(" + this.getDefaultDecimalPrecision() + "," + BigDecimalJavaTypeDescriptor.INSTANCE.getDefaultSqlScale(this, null) + ")) as char(254))) as ?2)";
                    }
                    case INTEGER: 
                    case LONG: 
                    case FIXED: {
                        return "cast(trim(cast(?1 as char(254))) as ?2)";
                    }
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampadd(sql_tsi_frac_second,mod(bigint(?2),1000000000),{fn timestampadd(sql_tsi_second,bigint((?2)/1000000000),?3)})}";
            }
        }
        return "{fn timestampadd(sql_tsi_?1,bigint(?2),?3)}";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampdiff(sql_tsi_frac_second,?2,?3)}";
            }
        }
        return "{fn timestampdiff(sql_tsi_?1,?2,?3)}";
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getVersion().isBefore(10, 7)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(10, 6) ? super.getSequenceSupport() : DerbySequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion().isBefore(10, 6) ? null : "select sys.sysschemas.schemaname as sequence_schema,sys.syssequences.* from sys.syssequences left join sys.sysschemas on sys.syssequences.schemaid=sys.sysschemas.schemaid";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getVersion().isBefore(10, 6) ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorDerbyDatabaseImpl.INSTANCE;
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        return DB2Dialect.selectNullString(sqlType);
    }

    @Override
    public boolean supportsCommentOn() {
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    @Override
    public RowLockStrategy getReadRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    @Override
    public String getForUpdateString() {
        return " for update with rs";
    }

    @Override
    public String getWriteLockString(int timeout) {
        return " for update with rs";
    }

    @Override
    public String getReadLockString(int timeout) {
        return " for read only with rs";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DB2IdentityColumnSupport();
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsOrderByInSubquery() {
        return false;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry();
        if (this.getVersion().isBefore(10, 7)) {
            jdbcTypeRegistry.addDescriptor(16, SmallIntJdbcType.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor(2, DecimalJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2014, TimestampJdbcType.INSTANCE);
        typeContributions.contributeJdbcTypeDescriptor(ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if ("40XL1".equals(sqlState) || "40XL2".equals(sqlState)) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new NotYetImplementedFor6Exception("format() function not supported on Derby");
    }

    private void registerDerbyKeywords() {
        this.registerKeyword("ADD");
        this.registerKeyword("ALL");
        this.registerKeyword("ALLOCATE");
        this.registerKeyword("ALTER");
        this.registerKeyword("AND");
        this.registerKeyword("ANY");
        this.registerKeyword("ARE");
        this.registerKeyword("AS");
        this.registerKeyword("ASC");
        this.registerKeyword("ASSERTION");
        this.registerKeyword("AT");
        this.registerKeyword("AUTHORIZATION");
        this.registerKeyword("AVG");
        this.registerKeyword("BEGIN");
        this.registerKeyword("BETWEEN");
        this.registerKeyword("BIT");
        this.registerKeyword("BOOLEAN");
        this.registerKeyword("BOTH");
        this.registerKeyword("BY");
        this.registerKeyword("CALL");
        this.registerKeyword("CASCADE");
        this.registerKeyword("CASCADED");
        this.registerKeyword("CASE");
        this.registerKeyword("CAST");
        this.registerKeyword("CHAR");
        this.registerKeyword("CHARACTER");
        this.registerKeyword("CHECK");
        this.registerKeyword("CLOSE");
        this.registerKeyword("COLLATE");
        this.registerKeyword("COLLATION");
        this.registerKeyword("COLUMN");
        this.registerKeyword("COMMIT");
        this.registerKeyword("CONNECT");
        this.registerKeyword("CONNECTION");
        this.registerKeyword("CONSTRAINT");
        this.registerKeyword("CONSTRAINTS");
        this.registerKeyword("CONTINUE");
        this.registerKeyword("CONVERT");
        this.registerKeyword("CORRESPONDING");
        this.registerKeyword("COUNT");
        this.registerKeyword("CREATE");
        this.registerKeyword("CURRENT");
        this.registerKeyword("CURRENT_DATE");
        this.registerKeyword("CURRENT_TIME");
        this.registerKeyword("CURRENT_TIMESTAMP");
        this.registerKeyword("CURRENT_USER");
        this.registerKeyword("CURSOR");
        this.registerKeyword("DEALLOCATE");
        this.registerKeyword("DEC");
        this.registerKeyword("DECIMAL");
        this.registerKeyword("DECLARE");
        this.registerKeyword("DEFERRABLE");
        this.registerKeyword("DEFERRED");
        this.registerKeyword("DELETE");
        this.registerKeyword("DESC");
        this.registerKeyword("DESCRIBE");
        this.registerKeyword("DIAGNOSTICS");
        this.registerKeyword("DISCONNECT");
        this.registerKeyword("DISTINCT");
        this.registerKeyword("DOUBLE");
        this.registerKeyword("DROP");
        this.registerKeyword("ELSE");
        this.registerKeyword("END");
        this.registerKeyword("ENDEXEC");
        this.registerKeyword("ESCAPE");
        this.registerKeyword("EXCEPT");
        this.registerKeyword("EXCEPTION");
        this.registerKeyword("EXEC");
        this.registerKeyword("EXECUTE");
        this.registerKeyword("EXISTS");
        this.registerKeyword("EXPLAIN");
        this.registerKeyword("EXTERNAL");
        this.registerKeyword("FALSE");
        this.registerKeyword("FETCH");
        this.registerKeyword("FIRST");
        this.registerKeyword("FLOAT");
        this.registerKeyword("FOR");
        this.registerKeyword("FOREIGN");
        this.registerKeyword("FOUND");
        this.registerKeyword("FROM");
        this.registerKeyword("FULL");
        this.registerKeyword("FUNCTION");
        this.registerKeyword("GET");
        this.registerKeyword("GET_CURRENT_CONNECTION");
        this.registerKeyword("GLOBAL");
        this.registerKeyword("GO");
        this.registerKeyword("GOTO");
        this.registerKeyword("GRANT");
        this.registerKeyword("GROUP");
        this.registerKeyword("HAVING");
        this.registerKeyword("HOUR");
        this.registerKeyword("IDENTITY");
        this.registerKeyword("IMMEDIATE");
        this.registerKeyword("IN");
        this.registerKeyword("INDICATOR");
        this.registerKeyword("INITIALLY");
        this.registerKeyword("INNER");
        this.registerKeyword("INOUT");
        this.registerKeyword("INPUT");
        this.registerKeyword("INSENSITIVE");
        this.registerKeyword("INSERT");
        this.registerKeyword("INT");
        this.registerKeyword("INTEGER");
        this.registerKeyword("INTERSECT");
        this.registerKeyword("INTO");
        this.registerKeyword("IS");
        this.registerKeyword("ISOLATION");
        this.registerKeyword("JOIN");
        this.registerKeyword("KEY");
        this.registerKeyword("LAST");
        this.registerKeyword("LEFT");
        this.registerKeyword("LIKE");
        this.registerKeyword("LONGINT");
        this.registerKeyword("LOWER");
        this.registerKeyword("LTRIM");
        this.registerKeyword("MATCH");
        this.registerKeyword("MAX");
        this.registerKeyword("MIN");
        this.registerKeyword("MINUTE");
        this.registerKeyword("NATIONAL");
        this.registerKeyword("NATURAL");
        this.registerKeyword("NCHAR");
        this.registerKeyword("NVARCHAR");
        this.registerKeyword("NEXT");
        this.registerKeyword("NO");
        this.registerKeyword("NOT");
        this.registerKeyword("NULL");
        this.registerKeyword("NULLIF");
        this.registerKeyword("NUMERIC");
        this.registerKeyword("OF");
        this.registerKeyword("ON");
        this.registerKeyword("ONLY");
        this.registerKeyword("OPEN");
        this.registerKeyword("OPTION");
        this.registerKeyword("OR");
        this.registerKeyword("ORDER");
        this.registerKeyword("OUT");
        this.registerKeyword("OUTER");
        this.registerKeyword("OUTPUT");
        this.registerKeyword("OVERLAPS");
        this.registerKeyword("PAD");
        this.registerKeyword("PARTIAL");
        this.registerKeyword("PREPARE");
        this.registerKeyword("PRESERVE");
        this.registerKeyword("PRIMARY");
        this.registerKeyword("PRIOR");
        this.registerKeyword("PRIVILEGES");
        this.registerKeyword("PROCEDURE");
        this.registerKeyword("PUBLIC");
        this.registerKeyword("READ");
        this.registerKeyword("REAL");
        this.registerKeyword("REFERENCES");
        this.registerKeyword("RELATIVE");
        this.registerKeyword("RESTRICT");
        this.registerKeyword("REVOKE");
        this.registerKeyword("RIGHT");
        this.registerKeyword("ROLLBACK");
        this.registerKeyword("ROWS");
        this.registerKeyword("RTRIM");
        this.registerKeyword("SCHEMA");
        this.registerKeyword("SCROLL");
        this.registerKeyword("SECOND");
        this.registerKeyword("SELECT");
        this.registerKeyword("SESSION_USER");
        this.registerKeyword("SET");
        this.registerKeyword("SMALLINT");
        this.registerKeyword("SOME");
        this.registerKeyword("SPACE");
        this.registerKeyword("SQL");
        this.registerKeyword("SQLCODE");
        this.registerKeyword("SQLERROR");
        this.registerKeyword("SQLSTATE");
        this.registerKeyword("SUBSTR");
        this.registerKeyword("SUBSTRING");
        this.registerKeyword("SUM");
        this.registerKeyword("SYSTEM_USER");
        this.registerKeyword("TABLE");
        this.registerKeyword("TEMPORARY");
        this.registerKeyword("TIMEZONE_HOUR");
        this.registerKeyword("TIMEZONE_MINUTE");
        this.registerKeyword("TO");
        this.registerKeyword("TRAILING");
        this.registerKeyword("TRANSACTION");
        this.registerKeyword("TRANSLATE");
        this.registerKeyword("TRANSLATION");
        this.registerKeyword("TRUE");
        this.registerKeyword("UNION");
        this.registerKeyword("UNIQUE");
        this.registerKeyword("UNKNOWN");
        this.registerKeyword("UPDATE");
        this.registerKeyword("UPPER");
        this.registerKeyword("USER");
        this.registerKeyword("USING");
        this.registerKeyword("VALUES");
        this.registerKeyword("VARCHAR");
        this.registerKeyword("VARYING");
        this.registerKeyword("VIEW");
        this.registerKeyword("WHENEVER");
        this.registerKeyword("WHERE");
        this.registerKeyword("WITH");
        this.registerKeyword("WORK");
        this.registerKeyword("WRITE");
        this.registerKeyword("XML");
        this.registerKeyword("XMLEXISTS");
        this.registerKeyword("XMLPARSE");
        this.registerKeyword("XMLSERIALIZE");
        this.registerKeyword("YEAR");
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "session.HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "session.HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "not logged";
    }

    @Override
    public boolean supportsTemporaryTablePrimaryKey() {
        return false;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "declare global temporary table";
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public boolean supportsPartitionBy() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(10, 4);
    }
}

