/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.ScrollMode;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.ColumnAliasExtractor;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.LobMergeStrategy;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.TypeNames;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.CastStrEmulation;
import org.hibernate.dialect.function.CoalesceIfnullEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CurrentFunction;
import org.hibernate.dialect.function.ExtractFunction;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.function.LocatePositionEmulation;
import org.hibernate.dialect.function.LpadRpadPadEmulation;
import org.hibernate.dialect.function.SqlFunction;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.StandardTemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.DefaultSchemaNameResolver;
import org.hibernate.engine.jdbc.env.spi.AnsiSqlKeywords;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.io.StreamCopier;
import org.hibernate.loader.BatchLoadSizingStrategy;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.CastType;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.NullOrdering;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardAuxiliaryDatabaseObjectExporter;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.internal.StandardUniqueKeyExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LongNVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.NCharJdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.NVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public abstract class Dialect
implements ConversionContext {
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final Pattern ESCAPE_CLOSING_COMMENT_PATTERN = Pattern.compile("\\*/");
    private static final Pattern ESCAPE_OPENING_COMMENT_PATTERN = Pattern.compile("/\\*");
    private static final double LOG_BASE2OF10 = Math.log(10.0) / Math.log(2.0);
    private final TypeNames typeNames = new TypeNames();
    private final TypeNames hibernateTypeNames = new TypeNames();
    private final Properties properties = new Properties();
    private final Set<String> sqlKeywords = new HashSet<String>();
    private final UniqueDelegate uniqueDelegate = new DefaultUniqueDelegate(this);
    private final SizeStrategy sizeStrategy = new SizeStrategyImpl();
    private final DatabaseVersion version;
    private static final List<Integer> ANSI_SQL_TYPES = List.of(16, -6, 5, 4, -5, 7, 6, 8, 2, 3, 91, 92, 2013, 93, 2014, 1, 12, 2005, -15, -9, 2011, -2, -3, 2004);
    protected static final LobMergeStrategy LEGACY_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            return target;
        }
    };
    protected static final LobMergeStrategy STREAM_XFER_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setBinaryStream(1L);
                    InputStream detachedStream = original.getBinaryStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge BLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeBlob(original, target, session);
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge CLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeClob(original, target, session);
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge NCLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeNClob(original, target, session);
        }
    };
    protected static final LobMergeStrategy NEW_LOCATOR_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            try {
                LobCreator lobCreator = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
                return original == null ? lobCreator.createBlob(ArrayHelper.EMPTY_BYTE_ARRAY) : lobCreator.createBlob(original.getBinaryStream(), original.length());
            }
            catch (SQLException e) {
                throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge BLOB data");
            }
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            try {
                LobCreator lobCreator = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
                return original == null ? lobCreator.createClob("") : lobCreator.createClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge CLOB data");
            }
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            try {
                LobCreator lobCreator = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
                return original == null ? lobCreator.createNClob("") : lobCreator.createNClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge NCLOB data");
            }
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> null;
    private final StandardTableExporter tableExporter = new StandardTableExporter(this);
    private final StandardSequenceExporter sequenceExporter = new StandardSequenceExporter(this);
    private final StandardIndexExporter indexExporter = new StandardIndexExporter(this);
    private final StandardForeignKeyExporter foreignKeyExporter = new StandardForeignKeyExporter(this);
    private final StandardUniqueKeyExporter uniqueKeyExporter = new StandardUniqueKeyExporter(this);
    private final StandardAuxiliaryDatabaseObjectExporter auxiliaryObjectExporter = new StandardAuxiliaryDatabaseObjectExporter(this);
    private final StandardTemporaryTableExporter temporaryTableExporter = new StandardTemporaryTableExporter(this);
    protected final BatchLoadSizingStrategy STANDARD_DEFAULT_BATCH_LOAD_SIZING_STRATEGY = new BatchLoadSizingStrategy(){

        @Override
        public int determineOptimalBatchLoadSize(int numberOfKeyColumns, int numberOfKeys, boolean inClauseParameterPaddingEnabled) {
            int paddedSize = inClauseParameterPaddingEnabled ? MathHelper.ceilingPowerOfTwo(numberOfKeys) : numberOfKeys;
            if (numberOfKeyColumns > 1) {
                return paddedSize;
            }
            int inExpressionCountLimit = Dialect.this.getInExpressionCountLimit();
            if (inExpressionCountLimit > 0) {
                if (paddedSize < inExpressionCountLimit) {
                    return paddedSize;
                }
                if (numberOfKeys < inExpressionCountLimit) {
                    return numberOfKeys;
                }
                return Dialect.this.getInExpressionCountLimit();
            }
            return paddedSize;
        }
    };

    @Deprecated
    protected Dialect() {
        this((DatabaseVersion)null);
    }

    protected Dialect(DatabaseVersion version) {
        this.version = version;
        this.beforeRegisteringColumnTypes(version);
        this.registerDefaultColumnTypes();
        this.registerHibernateTypes();
        this.registerDefaultKeywords();
        this.initDefaultProperties();
    }

    protected Dialect(DialectResolutionInfo info) {
        this.version = info.makeCopy();
        this.beforeRegisteringColumnTypes(info);
        this.registerDefaultColumnTypes();
        this.registerHibernateTypes();
        this.registerDefaultKeywords();
        this.registerKeywords(info);
        this.initDefaultProperties();
    }

    protected void initDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", Integer.toString(this.getDefaultStatementBatchSize()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", Boolean.toString(this.getDefaultUseStreamsForBinary()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", Boolean.toString(this.getDefaultNonContextualLobCreation()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", Boolean.toString(this.getDefaultUseGetGeneratedKeys()));
    }

    protected void beforeRegisteringColumnTypes(DialectResolutionInfo info) {
    }

    protected void beforeRegisteringColumnTypes(DatabaseVersion version) {
    }

    protected void registerDefaultColumnTypes() {
        this.registerDefaultColumnTypes(this.getMaxVarcharLength(), this.getMaxNVarcharLength(), this.getMaxVarbinaryLength());
    }

    protected void registerDefaultColumnTypes(int maxVarcharLength, int maxNVarcharLength, int maxVarBinaryLength) {
        block5: for (int typeCode : this.getSupportedJdbcTypeCodes()) {
            switch (typeCode) {
                case 12: {
                    this.registerColumnType(typeCode, maxVarcharLength, this.columnType(typeCode));
                    this.registerColumnType(typeCode, this.columnType(4001));
                    continue block5;
                }
                case -9: {
                    this.registerColumnType(typeCode, maxNVarcharLength, this.columnType(typeCode));
                    this.registerColumnType(typeCode, this.columnType(4002));
                    continue block5;
                }
                case -3: {
                    this.registerColumnType(typeCode, maxVarBinaryLength, this.columnType(typeCode));
                    this.registerColumnType(typeCode, this.columnType(4003));
                    continue block5;
                }
            }
            this.registerColumnType(typeCode, this.columnType(typeCode));
        }
    }

    protected List<Integer> getSupportedJdbcTypeCodes() {
        return ANSI_SQL_TYPES;
    }

    protected String columnType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case 16: {
                return "boolean";
            }
            case -6: {
                return "tinyint";
            }
            case 5: {
                return "smallint";
            }
            case 4: {
                return "integer";
            }
            case -5: {
                return "bigint";
            }
            case 6: {
                return "float($p)";
            }
            case 7: {
                return "real";
            }
            case 8: {
                return "double precision";
            }
            case 2: {
                return "numeric($p,$s)";
            }
            case 3: {
                return "decimal($p,$s)";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 2013: {
                return "time with time zone";
            }
            case 93: {
                return "timestamp($p)";
            }
            case 2014: {
                return "timestamp($p) with time zone";
            }
            case 1: {
                return "char($l)";
            }
            case 12: {
                return "varchar($l)";
            }
            case 2005: {
                return "clob";
            }
            case -15: {
                return "nchar($l)";
            }
            case -9: {
                return "nvarchar($l)";
            }
            case 2011: {
                return "nclob";
            }
            case -2: {
                return "binary($l)";
            }
            case -3: {
                return "varbinary($l)";
            }
            case 2004: {
                return "blob";
            }
            case 4001: {
                return this.columnType(2005);
            }
            case 4002: {
                return this.columnType(2011);
            }
            case 4003: {
                return this.columnType(2004);
            }
        }
        throw new IllegalArgumentException("unknown type: " + jdbcTypeCode);
    }

    protected void registerHibernateTypes() {
        this.registerHibernateType(16, StandardBasicTypes.BOOLEAN.getName());
        this.registerHibernateType(-7, 64L, StandardBasicTypes.LONG.getName());
        this.registerHibernateType(-7, 32L, StandardBasicTypes.INTEGER.getName());
        this.registerHibernateType(-7, 16L, StandardBasicTypes.SHORT.getName());
        this.registerHibernateType(-7, 8L, StandardBasicTypes.BYTE.getName());
        this.registerHibernateType(-7, 1L, StandardBasicTypes.BOOLEAN.getName());
        this.registerHibernateType(7, StandardBasicTypes.FLOAT.getName());
        this.registerHibernateType(8, StandardBasicTypes.DOUBLE.getName());
        this.registerHibernateType(6, StandardBasicTypes.DOUBLE.getName());
        this.registerHibernateType(2, StandardBasicTypes.BIG_DECIMAL.getName());
        this.registerHibernateType(3, StandardBasicTypes.BIG_DECIMAL.getName());
        this.registerHibernateType(-5, StandardBasicTypes.LONG.getName());
        this.registerHibernateType(4, StandardBasicTypes.INTEGER.getName());
        this.registerHibernateType(5, StandardBasicTypes.SHORT.getName());
        this.registerHibernateType(-6, StandardBasicTypes.BYTE.getName());
        this.registerHibernateType(1, 1L, StandardBasicTypes.CHARACTER.getName());
        this.registerHibernateType(1, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(12, 1L, StandardBasicTypes.CHARACTER.getName());
        this.registerHibernateType(12, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(-9, StandardBasicTypes.NSTRING.getName());
        this.registerHibernateType(-1, StandardBasicTypes.TEXT.getName());
        this.registerHibernateType(-16, StandardBasicTypes.NTEXT.getName());
        this.registerHibernateType(-2, StandardBasicTypes.BINARY.getName());
        this.registerHibernateType(-3, StandardBasicTypes.BINARY.getName());
        this.registerHibernateType(-4, StandardBasicTypes.IMAGE.getName());
        this.registerHibernateType(2004, StandardBasicTypes.BLOB.getName());
        this.registerHibernateType(2005, StandardBasicTypes.CLOB.getName());
        this.registerHibernateType(91, StandardBasicTypes.DATE.getName());
        this.registerHibernateType(92, StandardBasicTypes.TIME.getName());
        this.registerHibernateType(93, StandardBasicTypes.TIMESTAMP.getName());
    }

    protected void registerDefaultKeywords() {
        for (String keyword : AnsiSqlKeywords.INSTANCE.sql2003()) {
            this.registerKeyword(keyword);
        }
    }

    protected void registerKeywords(DialectResolutionInfo info) {
        for (String keyword : StringHelper.parseCommaSeparatedString(info.getSQLKeywords())) {
            this.registerKeyword(keyword);
        }
    }

    public DatabaseVersion getVersion() {
        return this.version;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        if (jdbcTypeCode == 1 && precision <= 4) {
            return displaySize;
        }
        return precision;
    }

    protected static Size binaryToDecimalPrecision(int code, Size size) {
        return code == 6 && size != null && size.getPrecision() != null ? Size.precision((int)Math.ceil((double)size.getPrecision().intValue() / LOG_BASE2OF10)) : size;
    }

    private static boolean isNumericType(int sqlType) {
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCharacterType(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isVarcharType(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isVarbinaryType(int sqlType) {
        switch (sqlType) {
            case -4: 
            case -3: {
                return true;
            }
        }
        return false;
    }

    public String getBooleanCheckCondition(String columnName, int sqlType, char falseChar, char trueChar) {
        if (Dialect.isCharacterType(sqlType)) {
            return columnName + " in ('" + falseChar + "','" + trueChar + "')";
        }
        if (Dialect.isNumericType(sqlType) && !this.supportsBitType()) {
            return columnName + " in (0,1)";
        }
        return null;
    }

    public String getEnumCheckCondition(String columnName, int sqlType, Class<? extends Enum<?>> enumClass) {
        if (Dialect.isCharacterType(sqlType)) {
            StringBuilder check = new StringBuilder();
            check.append(columnName).append(" in (");
            String separator = "";
            for (Enum<?> value : enumClass.getEnumConstants()) {
                check.append(separator).append('\'').append(value.name()).append('\'');
                separator = ",";
            }
            return check.append(')').toString();
        }
        if (Dialect.isNumericType(sqlType)) {
            int last = enumClass.getEnumConstants().length - 1;
            return columnName + " between 0 and " + last;
        }
        return null;
    }

    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        BasicTypeRegistry basicTypeRegistry = queryEngine.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<Date> timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        BasicType<Date> dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType<Date> timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType<Instant> instantType = basicTypeRegistry.resolve(StandardBasicTypes.INSTANT);
        BasicType<OffsetDateTime> offsetDateTimeType = basicTypeRegistry.resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        BasicType<LocalDateTime> localDateTimeType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE_TIME);
        BasicType<LocalTime> localTimeType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_TIME);
        BasicType<LocalDate> localDateType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE);
        CommonFunctionFactory.aggregates(this, queryEngine, SqlAstNodeRenderingMode.DEFAULT, "||", null);
        CommonFunctionFactory.everyAny_sumCase(queryEngine);
        CommonFunctionFactory.math(queryEngine);
        CommonFunctionFactory.trigonometry(queryEngine);
        CommonFunctionFactory.coalesce(queryEngine);
        CommonFunctionFactory.nullif(queryEngine);
        CommonFunctionFactory.leftRight(queryEngine);
        CommonFunctionFactory.replace(queryEngine);
        CommonFunctionFactory.concat(queryEngine);
        CommonFunctionFactory.lowerUpper(queryEngine);
        CommonFunctionFactory.substring(queryEngine);
        CommonFunctionFactory.locate(queryEngine);
        CommonFunctionFactory.length_characterLength(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("position", new LocatePositionEmulation(queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("overlay", new InsertSubstringOverlayEmulation(queryEngine.getTypeConfiguration(), false));
        queryEngine.getSqmFunctionRegistry().register("trim", new TrimFunction(this, queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("cast", new CastFunction(this, queryEngine.getPreferredSqlTypeCodeForBoolean()));
        queryEngine.getSqmFunctionRegistry().register("extract", new ExtractFunction(this));
        CommonFunctionFactory.leastGreatest(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("ifnull", new CoalesceIfnullEmulation());
        CommonFunctionFactory.pad(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("pad", new LpadRpadPadEmulation(queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("str", new CastStrEmulation(queryEngine.getTypeConfiguration()));
        CommonFunctionFactory.format_toChar(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("timestampadd", new TimestampaddFunction(this, queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("timestampdiff", new TimestampdiffFunction(this, queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("dateadd", "timestampadd");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("datediff", "timestampdiff");
        queryEngine.getSqmFunctionRegistry().register("current_date", new CurrentFunction("current_date", this.currentDate(), dateType));
        queryEngine.getSqmFunctionRegistry().register("current_time", new CurrentFunction("current_time", this.currentTime(), timeType));
        queryEngine.getSqmFunctionRegistry().register("current_timestamp", new CurrentFunction("current_timestamp", this.currentTimestamp(), timestampType));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current date", "current_date");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current time", "current_time");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current timestamp", "current_timestamp");
        queryEngine.getSqmFunctionRegistry().register("local_date", new CurrentFunction("local_date", this.currentDate(), localDateType));
        queryEngine.getSqmFunctionRegistry().register("local_time", new CurrentFunction("local_time", this.currentLocalTime(), localTimeType));
        queryEngine.getSqmFunctionRegistry().register("local_datetime", new CurrentFunction("local_datetime", this.currentLocalTimestamp(), localDateTimeType));
        queryEngine.getSqmFunctionRegistry().register("offset_datetime", new CurrentFunction("offset_datetime", this.currentTimestampWithTimeZone(), offsetDateTimeType));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("local date", "local_date");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("local time", "local_time");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("local datetime", "local_datetime");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("offset datetime", "offset_datetime");
        queryEngine.getSqmFunctionRegistry().register("instant", new CurrentFunction("instant", this.currentTimestamp(), instantType));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current_instant", "instant");
        queryEngine.getSqmFunctionRegistry().register("sql", new SqlFunction());
    }

    public String currentDate() {
        return "current_date";
    }

    public String currentTime() {
        return "current_time";
    }

    public String currentTimestamp() {
        return "current_timestamp";
    }

    public String currentLocalTime() {
        return this.currentTime();
    }

    public String currentLocalTimestamp() {
        return this.currentTimestamp();
    }

    public String currentTimestampWithTimeZone() {
        return this.currentTimestamp();
    }

    public String extractPattern(TemporalUnit unit) {
        return "extract(?1 from ?2)";
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'true' when 0 then 'false' else null end";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 'true' when 'N' then 'false' else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 'true' when 'F' then 'false' else null end";
                    }
                }
                break;
            }
            case INTEGER: 
            case LONG: {
                switch (from) {
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 1 when 'N' then 0 else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 1 when 'F' then 0 else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 1 when false then 0 else null end";
                    }
                }
                break;
            }
            case INTEGER_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then 1 when 'Y' then 1 when 'F' then 0 when 'N' then 0 else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "abs(sign(?1))";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 1 when 'N' then 0 else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 1 when 'F' then 0 else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 1 when false then 0 else null end";
                    }
                }
                break;
            }
            case YN_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then 'Y' when 'Y' then 'Y' when 'F' then 'N' when 'N' then 'N' else null end";
                    }
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'Y' when 0 then 'N' else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "case abs(sign(?1)) when 1 then 'Y' when 0 then 'N' else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 'Y' when 'F' then 'N' else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 'Y' when false then 'N' else null end";
                    }
                }
                break;
            }
            case TF_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then 'T' when 'Y' then 'T' when 'F' then 'F' when 'N' then 'F' else null end";
                    }
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'T' when 0 then 'F' else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "case abs(sign(?1)) when 1 then 'T' when 0 then 'F' else null end";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 'T' when 'N' then 'F' else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 'T' when false then 'F' else null end";
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then true when 'Y' then true when 'F' then false when 'N' then false else null end";
                    }
                    case INTEGER_BOOLEAN: 
                    case INTEGER: 
                    case LONG: {
                        return "(?1<>0)";
                    }
                    case YN_BOOLEAN: {
                        return "(?1<>'N')";
                    }
                    case TF_BOOLEAN: {
                        return "(?1<>'F')";
                    }
                }
            }
        }
        return "cast(?1 as ?2)";
    }

    public String trimPattern(TrimSpec specification, char character) {
        return character == ' ' ? "trim(" + specification + " from ?1)" : "trim(" + specification + " '" + character + "' from ?1)";
    }

    public boolean supportsFractionalTimestampArithmetic() {
        return true;
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        throw new NotYetImplementedFor6Exception();
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        throw new NotYetImplementedFor6Exception();
    }

    public boolean equivalentTypes(int typeCode1, int typeCode2) {
        return typeCode1 == typeCode2 || Dialect.isNumericOrDecimal(typeCode1) && Dialect.isNumericOrDecimal(typeCode2) || Dialect.isIntegral(typeCode1) && Dialect.isIntegral(typeCode2) || Dialect.isFloatOrRealOrDouble(typeCode1) && Dialect.isFloatOrRealOrDouble(typeCode2) || Dialect.isVarcharType(typeCode1) && Dialect.isVarcharType(typeCode2) || Dialect.isVarbinaryType(typeCode1) && Dialect.isVarbinaryType(typeCode2);
    }

    private static boolean isNumericOrDecimal(int typeCode) {
        return typeCode == 2 || typeCode == 3;
    }

    private static boolean isFloatOrRealOrDouble(int typeCode) {
        return typeCode == 6 || typeCode == 7 || typeCode == 8;
    }

    private static boolean isIntegral(int typeCode) {
        return typeCode == 4 || typeCode == -5 || typeCode == 5 || typeCode == -6;
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public int getDefaultStatementBatchSize() {
        return 1;
    }

    public boolean getDefaultUseStreamsForBinary() {
        return false;
    }

    public boolean getDefaultNonContextualLobCreation() {
        return false;
    }

    public boolean getDefaultUseGetGeneratedKeys() {
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        NationalizationSupport nationalizationSupport = this.getNationalizationSupport();
        if (nationalizationSupport == NationalizationSupport.EXPLICIT) {
            typeContributions.contributeJdbcTypeDescriptor(NCharJdbcType.INSTANCE);
            typeContributions.contributeJdbcTypeDescriptor(NVarcharJdbcType.INSTANCE);
            typeContributions.contributeJdbcTypeDescriptor(LongNVarcharJdbcType.INSTANCE);
            typeContributions.contributeJdbcTypeDescriptor(NClobJdbcType.DEFAULT);
        }
        if (this.useInputStreamToInsertBlob()) {
            typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry().addDescriptor(2005, ClobJdbcType.STREAM_BINDING);
        }
    }

    public String getRawTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        int paren = result.indexOf(40);
        return paren > 0 ? result.substring(0, paren) : result;
    }

    public String getRawTypeName(JdbcType jdbcType) throws HibernateException {
        return this.getRawTypeName(jdbcType.getDefaultSqlTypeCode());
    }

    public String getTypeName(JdbcType jdbcType) throws HibernateException {
        return this.getTypeName(jdbcType.getDefaultSqlTypeCode());
    }

    public String getTypeName(int code) throws HibernateException {
        switch (code) {
            case 2: 
            case 3: {
                return this.getTypeName(code, Size.precision(this.getDefaultDecimalPrecision()));
            }
            case 6: 
            case 7: {
                return this.getTypeName(code, Size.precision(this.getFloatPrecision()));
            }
            case 8: {
                return this.getTypeName(code, Size.precision(this.getDoublePrecision()));
            }
            case 93: 
            case 2014: {
                return this.getTypeName(code, Size.precision(this.getDefaultTimestampPrecision()));
            }
        }
        return this.getTypeName(code, Size.nil());
    }

    public String getTypeName(int code, Size size) throws HibernateException {
        String result = this.typeNames.get(code, size.getLength(), size.getPrecision(), size.getScale());
        if (result == null) {
            switch (code) {
                case -1: {
                    return this.getTypeName(12, size);
                }
                case -16: {
                    return this.getTypeName(-9, size);
                }
                case -4: {
                    return this.getTypeName(-3, size);
                }
            }
            throw new HibernateException(String.format("No type mapping for java.sql.Types code: %s, length: %s", code, size.getLength()));
        }
        return result;
    }

    public String getTypeName(JdbcType jdbcType, Size size) {
        return this.getTypeName(jdbcType.getDefaultSqlTypeCode(), size);
    }

    public String getCastTypeName(SqlExpressable type, Long length, Integer precision, Integer scale) {
        Size size;
        JdbcMapping jdbcMapping = type.getJdbcMapping();
        JdbcType jdbcType = jdbcMapping.getJdbcTypeDescriptor();
        JavaType javaType = jdbcMapping.getJavaTypeDescriptor();
        if (length == null && precision == null) {
            size = this.getSizeStrategy().resolveSize(jdbcType, javaType, precision, scale, length);
        } else {
            if (precision != null && scale == null) {
                scale = javaType.getDefaultSqlScale(this, jdbcType);
            }
            size = new Size().setLength(length).setPrecision(precision).setScale(scale);
        }
        return this.getTypeName(jdbcType, size);
    }

    protected void registerColumnType(int code, long capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    public LobMergeStrategy getLobMergeStrategy() {
        return NEW_LOCATOR_LOB_MERGE_STRATEGY;
    }

    public String getHibernateTypeName(int code) throws HibernateException {
        String result = this.hibernateTypeNames.get(code);
        if (result == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + code);
        }
        return result;
    }

    public boolean isTypeNameRegistered(String typeName) {
        return this.typeNames.containsTypeName(typeName);
    }

    public String getHibernateTypeName(int code, Integer length, Integer precision, Integer scale) throws HibernateException {
        String result = this.hibernateTypeNames.get(code, length.longValue(), precision, scale);
        if (result == null) {
            throw new HibernateException(String.format("No Hibernate type mapping for type [code=%s, length=%s]", code, length));
        }
        return result;
    }

    protected void registerHibernateType(int code, long capacity, String name) {
        this.hibernateTypeNames.put(code, capacity, name);
    }

    protected void registerHibernateType(int code, String name) {
        this.hibernateTypeNames.put(code, name);
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return this.getIdentityColumnSupport().supportsIdentityColumns() ? "identity" : "sequence";
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new IdentityColumnSupportImpl();
    }

    public SequenceSupport getSequenceSupport() {
        return NoSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getQuerySequencesString() == null ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorLegacyImpl.INSTANCE;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support GUIDs");
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public boolean supportsTemporaryTablePrimaryKey() {
        return true;
    }

    public LimitHandler getLimitHandler() {
        throw new UnsupportedOperationException("this dialect does not support query pagination");
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    public boolean isLockTimeoutParameterized() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public String getForUpdateString(LockOptions lockOptions) {
        return this.getForUpdateString(lockOptions.getLockMode(), lockOptions.getTimeOut());
    }

    private String getForUpdateString(LockMode lockMode, int timeout) {
        switch (lockMode) {
            case UPGRADE: {
                return this.getForUpdateString();
            }
            case PESSIMISTIC_READ: {
                return this.getReadLockString(timeout);
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(timeout);
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case UPGRADE_NOWAIT: 
            case FORCE: {
                return this.getForUpdateNowaitString();
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString();
            }
        }
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return this.getForUpdateString(lockMode, -1);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getReadLockString(timeout);
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    public RowLockStrategy getReadRowLockStrategy() {
        return this.getWriteRowLockStrategy();
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString();
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        Iterator<Map.Entry<String, LockMode>> itr = lockOptions.getAliasLockIterator();
        while (itr.hasNext()) {
            Map.Entry<String, LockMode> entry = itr.next();
            LockMode lm = entry.getValue();
            if (!lm.greaterThan(lockMode)) continue;
            lockMode = lm;
        }
        lockOptions.setLockMode(lockMode);
        return this.getForUpdateString(lockOptions);
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString() {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return tableName;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    public String getCreateTableString() {
        return "create table";
    }

    public String getAlterTableString(String tableName) {
        StringBuilder sb = new StringBuilder("alter table ");
        if (this.supportsIfExistsAfterAlterTable()) {
            sb.append("if exists ");
        }
        sb.append(tableName);
        return sb.toString();
    }

    public String getCreateMultisetTableString() {
        return this.getCreateTableString();
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new PersistentTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new PersistentTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return null;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public String getSelectClauseNullString(int sqlType) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsUnionInSubquery() {
        return this.supportsUnionAll();
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public boolean supportsNoColumnsInsert() {
        return true;
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String getCaseInsensitiveLike() {
        return "like";
    }

    public boolean supportsCaseInsensitiveLike() {
        return false;
    }

    public boolean supportsTruncateWithCast() {
        return true;
    }

    public String transformSelectString(String select) {
        return select;
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public int getMaxIdentifierLength() {
        return Integer.MAX_VALUE;
    }

    public String toBooleanValueString(boolean bool) {
        StringBuilder sb = new StringBuilder();
        this.appendBooleanValueString(sb::append, bool);
        return sb.toString();
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool ? (char)'1' : '0');
    }

    protected void registerKeyword(String word) {
        this.sqlKeywords.add(word.toLowerCase(Locale.ROOT));
    }

    public Set<String> getKeywords() {
        return this.sqlKeywords;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.applyIdentifierCasing(dbMetaData);
        builder.applyReservedWords(this.sqlKeywords);
        builder.setNameQualifierSupport(this.getNameQualifierSupport());
        return builder.build();
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final String quote(String name) {
        if (name == null) {
            return null;
        }
        if (name.charAt(0) == '`') {
            return this.openQuote() + name.substring(1, name.length() - 1) + this.closeQuote();
        }
        return name;
    }

    public Exporter<Table> getTableExporter() {
        return this.tableExporter;
    }

    public Exporter<Sequence> getSequenceExporter() {
        return this.sequenceExporter;
    }

    public Exporter<Index> getIndexExporter() {
        return this.indexExporter;
    }

    public Exporter<ForeignKey> getForeignKeyExporter() {
        return this.foreignKeyExporter;
    }

    public Exporter<Constraint> getUniqueKeyExporter() {
        return this.uniqueKeyExporter;
    }

    public Exporter<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjectExporter() {
        return this.auxiliaryObjectExporter;
    }

    public TemporaryTableExporter getTemporaryTableExporter() {
        return this.temporaryTableExporter;
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.PERSISTENT;
    }

    public String getTemporaryTableCreateOptions() {
        return null;
    }

    public String getTemporaryTableCreateCommand() {
        TemporaryTableKind kind = this.getSupportedTemporaryTableKind();
        switch (kind) {
            case PERSISTENT: {
                return "create table";
            }
            case LOCAL: {
                return "create local temporary table";
            }
            case GLOBAL: {
                return "create global temporary table";
            }
        }
        throw new UnsupportedOperationException("Unsupported kind: " + kind);
    }

    public String getTemporaryTableDropCommand() {
        return "drop table";
    }

    public String getTemporaryTableTruncateCommand() {
        return "delete from";
    }

    public String getCreateTemporaryTableColumnAnnotation(int sqlTypeCode) {
        return "";
    }

    public TempTableDdlTransactionHandling getTemporaryTableDdlTransactionHandling() {
        return TempTableDdlTransactionHandling.NONE;
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.CLEAN;
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.NONE;
    }

    public boolean canCreateCatalog() {
        return false;
    }

    public String[] getCreateCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No create catalog syntax supported by " + this.getClass().getName());
    }

    public String[] getDropCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No drop catalog syntax supported by " + this.getClass().getName());
    }

    public boolean canCreateSchema() {
        return true;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        return new String[]{"create schema " + schemaName};
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName};
    }

    public String getCurrentSchemaCommand() {
        return null;
    }

    public SchemaNameResolver getSchemaNameResolver() {
        return DefaultSchemaNameResolver.INSTANCE;
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddColumnSuffixString() {
        return "";
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30);
        res.append(" add constraint ").append(this.quote(constraintName)).append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + this.quote(constraintName) + " " + foreignKeyDefinition;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public String getNullColumnString(String columnType) {
        return this.getNullColumnString();
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return false;
    }

    public boolean supportsIfExistsAfterConstraintName() {
        return false;
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return false;
    }

    public String getDropTableString(String tableName) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(tableName).append(this.getCascadeConstraintsString());
        if (this.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public ColumnAliasExtractor getColumnAliasExtractor() {
        return ColumnAliasExtractor.COLUMN_LABEL_EXTRACTOR;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    public boolean supportsOrdinalSelectItemReference() {
        return true;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.GREATEST;
    }

    public boolean supportsNullPrecedence() {
        return true;
    }

    public boolean isAnsiNullOn() {
        return true;
    }

    public boolean requiresFloatCastingOfIntegerDivision() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropagation() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return true;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean requiresParensForTupleCounts() {
        return this.supportsTupleCounts();
    }

    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 0;
    }

    public boolean forceLobAsLastValue() {
        return false;
    }

    public boolean isEmptyStringTreatedAsNull() {
        return false;
    }

    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        return false;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public String getQueryHintString(String query, List<String> hintList) {
        String hints = String.join((CharSequence)", ", hintList);
        return StringHelper.isEmpty(hints) ? query : this.getQueryHintString(query, hints);
    }

    public String getQueryHintString(String query, String hints) {
        return query;
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.SCROLL_INSENSITIVE;
    }

    public boolean supportsOffsetInSubquery() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return true;
    }

    public boolean supportsSubqueryInSelect() {
        return true;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return false;
    }

    public boolean supportsLateral() {
        return false;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.NO_REF_CURSOR_INSTANCE;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return null;
    }

    public BatchLoadSizingStrategy getDefaultBatchLoadSizingStrategy() {
        return this.STANDARD_DEFAULT_BATCH_LOAD_SIZING_STRATEGY;
    }

    public boolean isJdbcLogWarningsEnabledByDefault() {
        return true;
    }

    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
    }

    public boolean supportsPartitionBy() {
        return false;
    }

    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData != null && databaseMetaData.supportsNamedParameters();
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.EXPLICIT;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public boolean supportsNonQueryWithCTE() {
        return false;
    }

    public boolean supportsValuesList() {
        return false;
    }

    public boolean supportsValuesListForInsert() {
        return true;
    }

    public boolean supportsSkipLocked() {
        return false;
    }

    public boolean supportsNoWait() {
        return false;
    }

    public boolean supportsWait() {
        return this.supportsNoWait();
    }

    public String inlineLiteral(String literal) {
        StringBuilder sb = new StringBuilder(literal.length() + 2);
        this.appendLiteral(sb::append, literal);
        return sb.toString();
    }

    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\'') {
                appender.appendSql('\'');
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return true;
    }

    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (queryOptions.getDatabaseHints() != null && queryOptions.getDatabaseHints().size() > 0) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        return sql;
    }

    protected String prependComment(String sql, String comment) {
        return "/* " + Dialect.escapeComment(comment) + " */ " + sql;
    }

    public static String escapeComment(String comment) {
        if (StringHelper.isNotEmpty(comment)) {
            String escaped = ESCAPE_CLOSING_COMMENT_PATTERN.matcher(comment).replaceAll("*\\\\/");
            return ESCAPE_OPENING_COMMENT_PATTERN.matcher(escaped).replaceAll("/\\\\*");
        }
        return comment;
    }

    public HqlTranslator getHqlTranslator() {
        return null;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return null;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return null;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.EXPRESSION;
    }

    public SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    public int getMaxVarcharLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxNVarcharLength() {
        return this.getMaxVarcharLength();
    }

    public int getMaxVarbinaryLength() {
        return this.getMaxVarcharLength();
    }

    public long getDefaultLobLength() {
        return 0x100000L;
    }

    public int getDefaultDecimalPrecision() {
        return 38;
    }

    public int getDefaultTimestampPrecision() {
        return 6;
    }

    public int getFloatPrecision() {
        return 24;
    }

    public int getDoublePrecision() {
        return 53;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1L;
    }

    public boolean supportsBitType() {
        return true;
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("X'");
        PrimitiveByteArrayJavaTypeDescriptor.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public RowLockStrategy getLockRowIdentifier(LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadRowLockStrategy();
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_WRITE: 
            case UPGRADE: 
            case UPGRADE_NOWAIT: 
            case FORCE: 
            case UPGRADE_SKIPLOCKED: 
            case WRITE: {
                return this.getWriteRowLockStrategy();
            }
        }
        return RowLockStrategy.NONE;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, true, false).result());
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "dd";
            }
            case DAY_OF_YEAR: {
                return "dy";
            }
            case DAY_OF_WEEK: {
                return "dw";
            }
            case OFFSET: 
            case NATIVE: 
            case NANOSECOND: 
            case DATE: 
            case TIME: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: {
                throw new IllegalArgumentException("illegal field: " + unit);
            }
        }
        return unit.toString();
    }

    public String translateDurationField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: 
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case OFFSET: 
            case DATE: 
            case TIME: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: 
            case TIMEZONE_HOUR: 
            case TIMEZONE_MINUTE: {
                throw new IllegalArgumentException("illegal unit: " + unit);
            }
            case NATIVE: {
                return "nanosecond";
            }
        }
        return unit.toString();
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, calendar);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, calendar, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendIntervalLiteral(SqlAppender appender, Duration literal) {
        appender.appendSql("interval '");
        appender.appendSql(literal.getSeconds());
        appender.appendSql('.');
        appender.appendSql(literal.getNano());
        appender.appendSql('\'');
    }

    public boolean supportsTemporalLiteralOffset() {
        return false;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NONE;
    }

    public class SizeStrategyImpl
    implements SizeStrategy {
        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            Size size = new Size();
            int jdbcTypeCode = jdbcType.getDefaultSqlTypeCode();
            switch (jdbcTypeCode) {
                case -7: {
                    if (javaType.getJavaTypeClass() == Boolean.class && length != null && length == 255L) {
                        length = null;
                    }
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this, jdbcType));
                    break;
                }
                case -15: 
                case 1: {
                    if (length != null && length == 255L && (javaType.getJavaTypeClass() == Character.class || javaType.getJavaTypeClass() == UUID.class)) {
                        length = null;
                    }
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this, jdbcType));
                    break;
                }
                case -9: 
                case -3: 
                case -2: 
                case 12: {
                    if (javaType.getJavaTypeClass() == UUID.class && length != null && length == 255L) {
                        length = null;
                    }
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this, jdbcType));
                    break;
                }
                case -16: 
                case -4: 
                case -1: {
                    size.setLength(javaType.getLongSqlLength());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    if (scale != null && scale != 0) {
                        throw new IllegalArgumentException("scale has no meaning for floating point numbers");
                    }
                    if (precision == null) break;
                    precision = (int)Math.ceil((double)precision.intValue() * LOG_BASE2OF10);
                    break;
                }
                case 93: 
                case 2014: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    if (scale == null || scale == 0) break;
                    throw new IllegalArgumentException("scale has no meaning for timestamps");
                }
                case 2: 
                case 3: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    size.setScale(javaType.getDefaultSqlScale(Dialect.this, jdbcType));
                    break;
                }
                case 2004: 
                case 2005: {
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this, jdbcType));
                    break;
                }
                case 3100: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    size.setScale(javaType.getDefaultSqlScale(Dialect.this, jdbcType));
                }
            }
            if (precision != null) {
                size.setPrecision(precision);
            }
            if (scale != null) {
                size.setScale(scale);
            }
            if (length != null) {
                size.setLength(length);
            }
            return size;
        }
    }

    public static interface SizeStrategy {
        public Size resolveSize(JdbcType var1, JavaType<?> var2, Integer var3, Integer var4, Long var5);
    }
}

