/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DurationIntervalSecondJdbcType;
import org.hibernate.dialect.H2SqlAstTranslator;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.H2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.NullOrdering;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorH2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class H2Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(H2Dialect.class);
    private final LimitHandler limitHandler;
    private final boolean cascadeConstraints;
    private final boolean useLocalTime;
    private final boolean supportsTuplesInSubqueries;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private final String querySequenceString;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String constraintName = null;
        if (sqle.getSQLState().startsWith("23")) {
            String message = sqle.getMessage();
            int idx = message.indexOf("violation: ");
            if (idx > 0) {
                constraintName = message.substring(idx + "violation: ".length());
            }
            if (sqle.getSQLState().equals("23506")) {
                constraintName = constraintName.substring(1, constraintName.indexOf(":"));
            }
        }
        return constraintName;
    });

    public H2Dialect(DialectResolutionInfo info) {
        this(H2Dialect.parseVersion(info));
        this.registerKeywords(info);
    }

    public H2Dialect() {
        this(SimpleDatabaseVersion.ZERO_VERSION);
    }

    public H2Dialect(DatabaseVersion version) {
        super(version);
        LimitHandler limitHandler = this.limitHandler = version.isSameOrAfter(1, 4, 195) ? OffsetFetchLimitHandler.INSTANCE : LimitOffsetLimitHandler.INSTANCE;
        if (version.isBefore(1, 2, 139)) {
            LOG.unsupportedMultiTableBulkHqlJpaql(version.getMajor(), version.getMinor(), version.getMicro());
        }
        this.supportsTuplesInSubqueries = version.isSameOrAfter(1, 4, 198);
        this.cascadeConstraints = version.isSameOrAfter(1, 4, 200);
        this.useLocalTime = version.isSameOrAfter(1, 4, 200);
        if (version.isSameOrAfter(1, 4, 32)) {
            this.sequenceInformationExtractor = version.isSameOrAfter(1, 4, 201) ? SequenceInformationExtractorLegacyImpl.INSTANCE : SequenceInformationExtractorH2DatabaseImpl.INSTANCE;
            this.querySequenceString = "select * from INFORMATION_SCHEMA.SEQUENCES";
            this.registerColumnType(3, "numeric($p,$s)");
            if (version.isSameOrAfter(1, 4, 197)) {
                this.registerColumnType(3000, "uuid");
                this.registerColumnType(3200, "geometry");
                if (version.isSameOrAfter(1, 4, 198)) {
                    this.registerColumnType(3100, "interval second($p,$s)");
                }
            }
        } else {
            this.sequenceInformationExtractor = SequenceInformationExtractorNoOpImpl.INSTANCE;
            this.querySequenceString = null;
        }
    }

    private static DatabaseVersion parseVersion(DialectResolutionInfo info) {
        return DatabaseVersion.make(info.getMajor(), info.getMinor(), H2Dialect.parseBuildId(info));
    }

    private static int parseBuildId(DialectResolutionInfo info) {
        String databaseVersion = info.getDatabaseVersion();
        if (databaseVersion == null) {
            return 0;
        }
        String[] bits = databaseVersion.split("[. ]");
        return bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    protected String columnType(int jdbcTypeCode) {
        if (jdbcTypeCode == 2 && this.getVersion().isBefore(2)) {
            return super.columnType(3);
        }
        switch (jdbcTypeCode) {
            case 4001: 
            case 4002: {
                return "varchar";
            }
            case 4003: {
                return "varbinary";
            }
            case 2003: {
                return "array";
            }
        }
        return super.columnType(jdbcTypeCode);
    }

    @Override
    protected List<Integer> getSupportedJdbcTypeCodes() {
        ArrayList<Integer> typeCodes = new ArrayList<Integer>(super.getSupportedJdbcTypeCodes());
        typeCodes.add(2003);
        return typeCodes;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry();
        if (this.getVersion().isSameOrAfter(1, 4, 197)) {
            jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
        }
        if (this.getVersion().isSameOrAfter(1, 4, 198)) {
            jdbcTypeRegistry.addDescriptorIfAbsent(DurationIntervalSecondJdbcType.INSTANCE);
        }
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public boolean hasOddDstBehavior() {
        return this.getVersion().isSame(1, 4, 200);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.aggregates(this, queryEngine, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, "||", null);
        CommonFunctionFactory.avg_castingNonDoubleArguments(this, queryEngine, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.bitand(queryEngine);
        CommonFunctionFactory.bitor(queryEngine);
        CommonFunctionFactory.bitxor(queryEngine);
        CommonFunctionFactory.bitAndOr(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayOfWeekMonthYear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        if (this.useLocalTime) {
            CommonFunctionFactory.localtimeLocaltimestamp(queryEngine);
        }
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.trim1(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.nowCurdateCurtime(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.everyAny_boolAndOr(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        if (this.getVersion().isSame(1, 4, 200)) {
            CommonFunctionFactory.format_toChar(queryEngine);
        } else {
            CommonFunctionFactory.format_formatdatetime(queryEngine);
        }
        CommonFunctionFactory.rownum(queryEngine);
    }

    @Override
    public int getMaxVarcharLength() {
        return 0x100000;
    }

    @Override
    public String currentTime() {
        return this.useLocalTime ? "localtime" : super.currentTime();
    }

    @Override
    public String currentTimestamp() {
        return this.useLocalTime ? "localtimestamp" : super.currentTimestamp();
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new H2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.SECOND ? "(" + super.extractPattern(unit) + "+extract(nanosecond from ?2)/1e9)" : super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1,?2,?3)";
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return !this.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public String getCascadeConstraintsString() {
        return this.cascadeConstraints ? " cascade " : super.getCascadeConstraintsString();
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return H2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.FIRST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            switch (errorCode) {
                case 40001: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 50200: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 90006: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.ALIAS;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion().isSameOrAfter(1, 4, 198);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new H2IdentityColumnSupport();
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        if (this.getVersion().isSame(1, 4, 200)) {
            appender.appendSql(OracleDialect.datetimeFormat(format, true, true).result());
        } else {
            appender.appendSql(new Replacer(format, "'", "''").replace("e", "u").replace("xxx", "XXX").replace("xx", "XX").replace("x", "X").result());
        }
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return unit.toString();
    }
}

