/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.type.StandardBasicTypes;

public class HANAColumnStoreDialect
extends AbstractHANADialect {
    public HANAColumnStoreDialect(DialectResolutionInfo info) {
        this(AbstractHANADialect.createVersion(info));
        this.registerKeywords(info);
    }

    public HANAColumnStoreDialect() {
        this(DatabaseVersion.make(1, 0, 120));
    }

    public HANAColumnStoreDialect(DatabaseVersion version) {
        super(version);
        if (version.isSameOrAfter(4)) {
            this.registerColumnType(1, "nvarchar($l)");
            this.registerColumnType(12, this.getMaxVarcharLength(), "nvarchar($l)");
            this.registerColumnType(12, "nclob");
            this.registerColumnType(2005, "nclob");
            this.registerHibernateType(2005, StandardBasicTypes.MATERIALIZED_NCLOB.getName());
            this.registerHibernateType(-15, StandardBasicTypes.NSTRING.getName());
            this.registerHibernateType(1, StandardBasicTypes.CHARACTER.getName());
            this.registerHibernateType(1, 1L, StandardBasicTypes.CHARACTER.getName());
            this.registerHibernateType(1, 5000L, StandardBasicTypes.NSTRING.getName());
            this.registerHibernateType(12, StandardBasicTypes.NSTRING.getName());
            this.registerHibernateType(-1, StandardBasicTypes.NTEXT.getName());
            this.registerHanaCloudKeywords();
        }
    }

    @Override
    public int getMaxVarcharLength() {
        return 5000;
    }

    private void registerHanaCloudKeywords() {
        this.registerKeyword("array");
        this.registerKeyword("at");
        this.registerKeyword("authorization");
        this.registerKeyword("between");
        this.registerKeyword("by");
        this.registerKeyword("collate");
        this.registerKeyword("empty");
        this.registerKeyword("filter");
        this.registerKeyword("grouping");
        this.registerKeyword("no");
        this.registerKeyword("not");
        this.registerKeyword("of");
        this.registerKeyword("over");
        this.registerKeyword("recursive");
        this.registerKeyword("row");
        this.registerKeyword("table");
        this.registerKeyword("to");
        this.registerKeyword("window");
        this.registerKeyword("within");
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerNamed("score", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE));
        queryEngine.getSqmFunctionRegistry().registerNamed("snippets");
        queryEngine.getSqmFunctionRegistry().registerNamed("highlighted");
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("contains", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN), "contains(?1,?2)", "contains(?1,?2,?3)");
    }

    @Override
    public String getCreateTableString() {
        return "create column table";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "create global temporary row table";
    }

    @Override
    public String getTemporaryTableTruncateCommand() {
        return "truncate table";
    }

    @Override
    protected boolean supportsAsciiStringTypes() {
        return true;
    }

    @Override
    protected Boolean useUnicodeStringTypesDefault() {
        return true;
    }
}

