/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TrimFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;

    public TrimFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super("trim", StandardArgumentsValidators.exactly(3), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        TrimSpec specification = ((TrimSpecification)sqlAstArguments.get(0)).getSpecification();
        Character trimCharacter = (Character)((QueryLiteral)sqlAstArguments.get(1)).getLiteralValue();
        Expression sourceExpr = (Expression)sqlAstArguments.get(2);
        String trim = this.dialect.trimPattern(specification, trimCharacter.charValue());
        new PatternRenderer(trim).render(sqlAppender, Collections.singletonList(sourceExpr), walker);
    }

    @Override
    public String getArgumentListSignature() {
        return "([[{leading|trailing|both} ][arg0 ]from] arg1)";
    }
}

