/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sequence;

import org.hibernate.MappingException;
import org.hibernate.dialect.sequence.SequenceSupport;

public final class H2SequenceSupport
implements SequenceSupport {
    public static final SequenceSupport INSTANCE = new H2SequenceSupport();

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence if exists " + sequenceName;
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getSelectSequencePreviousValString(String sequenceName) throws MappingException {
        return sequenceName + ".currval";
    }
}

