/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import org.hibernate.InstantiationException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;

public class UnsavedValueFactory {
    public static IdentifierValue getUnsavedIdentifierValue(KeyValue bootIdMapping, JavaType<?> idJtd, Getter getter, Supplier<?> templateInstanceAccess, SessionFactoryImplementor sessionFactory) {
        String unsavedValue = bootIdMapping.getNullValue();
        if (unsavedValue == null) {
            if (getter != null && templateInstanceAccess != null) {
                Object templateInstance = templateInstanceAccess.get();
                Object defaultValue = getter.get(templateInstance);
                return new IdentifierValue(defaultValue);
            }
            if (idJtd instanceof PrimitiveJavaType) {
                return new IdentifierValue(((PrimitiveJavaType)idJtd).getDefaultValue());
            }
            return IdentifierValue.NULL;
        }
        if ("null".equals(unsavedValue)) {
            return IdentifierValue.NULL;
        }
        if ("undefined".equals(unsavedValue)) {
            return IdentifierValue.UNDEFINED;
        }
        if ("none".equals(unsavedValue)) {
            return IdentifierValue.NONE;
        }
        if ("any".equals(unsavedValue)) {
            return IdentifierValue.ANY;
        }
        return new IdentifierValue(idJtd.fromString(unsavedValue));
    }

    public static VersionValue getUnsavedVersionValue(KeyValue bootVersionMapping, VersionJavaType jtd, Getter getter, Supplier<?> templateInstanceAccess, SessionFactoryImplementor sessionFactory) {
        String unsavedValue = bootVersionMapping.getNullValue();
        if (unsavedValue == null) {
            if (getter != null && templateInstanceAccess != null) {
                Object templateInstance = templateInstanceAccess.get();
                Object defaultValue = getter.get(templateInstance);
                Object seedValue = jtd.seed(null);
                return jtd.areEqual(seedValue, defaultValue) ? VersionValue.UNDEFINED : new VersionValue(defaultValue);
            }
            return VersionValue.UNDEFINED;
        }
        if ("undefined".equals(unsavedValue)) {
            return VersionValue.UNDEFINED;
        }
        if ("null".equals(unsavedValue)) {
            return VersionValue.NULL;
        }
        if ("negative".equals(unsavedValue)) {
            return VersionValue.NEGATIVE;
        }
        throw new MappingException("Could not parse version unsaved-value: " + unsavedValue);
    }

    private static Object instantiate(Constructor constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InstantiationException("could not instantiate test object", constructor.getDeclaringClass(), e);
        }
    }

    public static <X> VersionValue getUnsavedVersionValue(String versionUnsavedValue, Getter versionGetter, VersionJavaType<X> versionType, Constructor constructor) {
        if (versionUnsavedValue == null) {
            if (constructor != null) {
                Object defaultValue = versionGetter.get(UnsavedValueFactory.instantiate(constructor));
                return versionType.areEqual(versionType.seed(null), defaultValue) ? VersionValue.UNDEFINED : new VersionValue(defaultValue);
            }
            return VersionValue.UNDEFINED;
        }
        if ("undefined".equals(versionUnsavedValue)) {
            return VersionValue.UNDEFINED;
        }
        if ("null".equals(versionUnsavedValue)) {
            return VersionValue.NULL;
        }
        if ("negative".equals(versionUnsavedValue)) {
            return VersionValue.NEGATIVE;
        }
        throw new MappingException("Could not parse version unsaved-value: " + versionUnsavedValue);
    }

    private UnsavedValueFactory() {
    }
}

