/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Objects;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;

public class FilterJdbcParameter {
    private final JdbcParameter parameter;
    private final JdbcMapping jdbcMapping;
    private final Object jdbcParameterValue;

    public FilterJdbcParameter(JdbcMapping jdbcMapping, Object jdbcParameterValue) {
        this.parameter = new JdbcParameterImpl(jdbcMapping);
        this.jdbcMapping = jdbcMapping;
        this.jdbcParameterValue = jdbcParameterValue;
    }

    public JdbcParameter getParameter() {
        return this.parameter;
    }

    public JdbcParameterBinder getBinder() {
        return this.parameter.getParameterBinder();
    }

    public JdbcParameterBinding getBinding() {
        return new JdbcParameterBindingImpl(this.jdbcMapping, this.jdbcParameterValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterJdbcParameter that = (FilterJdbcParameter)o;
        return Objects.equals(this.parameter, that.parameter) && Objects.equals(this.jdbcMapping, that.jdbcMapping) && Objects.equals(this.jdbcParameterValue, that.jdbcParameterValue);
    }

    public int hashCode() {
        return Objects.hash(this.parameter, this.jdbcMapping, this.jdbcParameterValue);
    }
}

