/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractNaturalIdLoader;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;

public class SimpleNaturalIdLoader<T>
extends AbstractNaturalIdLoader<T> {
    public SimpleNaturalIdLoader(SimpleNaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        super(naturalIdMapping, entityDescriptor);
    }

    @Override
    protected SimpleNaturalIdMapping naturalIdMapping() {
        return (SimpleNaturalIdMapping)super.naturalIdMapping();
    }

    @Override
    protected void applyNaturalIdRestriction(Object bindValue, TableGroup rootTableGroup, Consumer<Predicate> predicateConsumer, BiConsumer<JdbcParameter, JdbcParameterBinding> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState, SharedSessionContractImplementor session) {
        if (bindValue == null) {
            this.naturalIdMapping().getAttribute().forEachSelectable((index, selectable) -> {
                Expression columnReference = this.resolveColumnReference(rootTableGroup, selectable, sqlAstCreationState.getSqlExpressionResolver(), session.getFactory());
                predicateConsumer.accept(new NullnessPredicate(columnReference));
            });
        } else {
            this.naturalIdMapping().getAttribute().breakDownJdbcValues(bindValue, (jdbcValue, jdbcValueMapping) -> {
                Expression columnReference = this.resolveColumnReference(rootTableGroup, jdbcValueMapping, sqlAstCreationState.getSqlExpressionResolver(), session.getFactory());
                if (jdbcValue == null) {
                    predicateConsumer.accept(new NullnessPredicate(columnReference));
                } else {
                    JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcValueMapping.getJdbcMapping());
                    ComparisonPredicate predicate = new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter);
                    predicateConsumer.accept(predicate);
                    jdbcParameterConsumer.accept(jdbcParameter, new JdbcParameterBindingImpl(jdbcValueMapping.getJdbcMapping(), jdbcValue));
                }
            }, session);
        }
    }
}

