/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.metamodel.internal.PojoInstantiatorImpl;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableInstantiatorPojoStandard
extends AbstractPojoInstantiator
implements StandardEmbeddableInstantiator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PojoInstantiatorImpl.class);
    private final Supplier<EmbeddableMappingType> embeddableMappingAccess;
    private final boolean constructorInjection = false;
    private final Constructor<?> constructor;

    public EmbeddableInstantiatorPojoStandard(JavaType<?> javaTypeDescriptor, Supplier<EmbeddableMappingType> embeddableMappingAccess) {
        super(javaTypeDescriptor.getJavaTypeClass());
        this.embeddableMappingAccess = embeddableMappingAccess;
        this.constructor = EmbeddableInstantiatorPojoStandard.resolveConstructor(javaTypeDescriptor.getJavaTypeClass());
    }

    protected static Constructor<?> resolveConstructor(Class<?> mappedPojoClass) {
        try {
            return ReflectHelper.getDefaultConstructor(mappedPojoClass);
        }
        catch (PropertyNotFoundException e) {
            LOG.noDefaultConstructor(mappedPojoClass.getName());
            return null;
        }
    }

    @Override
    public Object instantiate(Supplier<Object[]> valuesAccess, SessionFactoryImplementor sessionFactory) {
        if (this.isAbstract()) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.getMappedPojoClass());
        }
        if (this.constructor == null) {
            throw new InstantiationException("Unable to locate constructor for embeddable", this.getMappedPojoClass());
        }
        try {
            Object instance = this.constructor.newInstance(new Object[0]);
            if (valuesAccess != null) {
                this.embeddableMappingAccess.get().setValues(instance, valuesAccess.get());
            }
            return instance;
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.getMappedPojoClass(), e);
        }
    }
}

