/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.internal.AbstractEntityInstantiatorPojo;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityInstantiatorPojoStandard
extends AbstractEntityInstantiatorPojo {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityInstantiatorPojoStandard.class);
    private final EntityMetamodel entityMetamodel;
    private final Class<?> proxyInterface;
    private final boolean applyBytecodeInterception;
    private final Constructor<?> constructor;

    public EntityInstantiatorPojoStandard(EntityMetamodel entityMetamodel, PersistentClass persistentClass, JavaType<?> javaTypeDescriptor) {
        super(entityMetamodel, persistentClass, javaTypeDescriptor);
        this.entityMetamodel = entityMetamodel;
        this.proxyInterface = persistentClass.getProxyInterface();
        this.constructor = this.isAbstract() ? null : EntityInstantiatorPojoStandard.resolveConstructor(this.getMappedPojoClass());
        this.applyBytecodeInterception = PersistentAttributeInterceptable.class.isAssignableFrom(persistentClass.getMappedClass());
    }

    protected static Constructor<?> resolveConstructor(Class<?> mappedPojoClass) {
        try {
            return ReflectHelper.getDefaultConstructor(mappedPojoClass);
        }
        catch (PropertyNotFoundException e) {
            LOG.noDefaultConstructor(mappedPojoClass.getName());
            return null;
        }
    }

    @Override
    public boolean canBeInstantiated() {
        return this.constructor != null;
    }

    @Override
    protected Object applyInterception(Object entity) {
        if (!this.applyBytecodeInterception) {
            return entity;
        }
        LazyAttributeLoadingInterceptor interceptor = new LazyAttributeLoadingInterceptor(this.entityMetamodel.getName(), null, this.entityMetamodel.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getLazyAttributeNames(), null);
        ((PersistentAttributeInterceptable)entity).$$_hibernate_setInterceptor(interceptor);
        return entity;
    }

    @Override
    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        return super.isInstance(object, sessionFactory) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }

    @Override
    public Object instantiate(SessionFactoryImplementor sessionFactory) {
        if (this.isAbstract()) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.getMappedPojoClass());
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.getMappedPojoClass());
        }
        try {
            return this.applyInterception(this.constructor.newInstance(null));
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.getMappedPojoClass(), e);
        }
    }
}

