/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyPojo;
import org.hibernate.metamodel.internal.EntityInstantiatorPojoOptimized;
import org.hibernate.metamodel.internal.EntityInstantiatorPojoStandard;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.ProxyFactoryHelper;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class EntityRepresentationStrategyPojoStandard
implements EntityRepresentationStrategy {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityRepresentationStrategyPojoStandard.class);
    private final JavaType<?> mappedJtd;
    private final JavaType<?> proxyJtd;
    private final boolean isBytecodeEnhanced;
    private final boolean lifecycleImplementor;
    private final ReflectionOptimizer reflectionOptimizer;
    private final ProxyFactory proxyFactory;
    private final EntityInstantiator instantiator;
    private final StrategySelector strategySelector;
    private final String identifierPropertyName;
    private final PropertyAccess identifierPropertyAccess;
    private final Map<String, PropertyAccess> propertyAccessMap = new ConcurrentHashMap<String, PropertyAccess>();
    private final EmbeddableRepresentationStrategyPojo mapsIdRepresentationStrategy;

    public EntityRepresentationStrategyPojoStandard(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        JavaTypeRegistry jtdRegistry = creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        Class<?> mappedJavaType = bootDescriptor.getMappedClass();
        this.mappedJtd = jtdRegistry.resolveEntityTypeDescriptor(mappedJavaType);
        Class<?> proxyJavaType = bootDescriptor.getProxyInterface();
        this.proxyJtd = proxyJavaType != null ? jtdRegistry.getDescriptor(proxyJavaType) : null;
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(mappedJavaType);
        this.isBytecodeEnhanced = PersistentAttributeInterceptable.class.isAssignableFrom(mappedJavaType);
        Property identifierProperty = bootDescriptor.getIdentifierProperty();
        if (identifierProperty == null) {
            this.identifierPropertyName = null;
            this.identifierPropertyAccess = null;
            KeyValue bootDescriptorIdentifier = bootDescriptor.getIdentifier();
            this.mapsIdRepresentationStrategy = bootDescriptorIdentifier instanceof Component ? (bootDescriptor.getIdentifierMapper() != null ? new EmbeddableRepresentationStrategyPojo(bootDescriptor.getIdentifierMapper(), () -> ((CompositeTypeImplementor)bootDescriptor.getIdentifierMapper().getType()).getMappingModelPart().getEmbeddableTypeDescriptor(), null, creationContext) : (bootDescriptorIdentifier != null ? new EmbeddableRepresentationStrategyPojo((Component)bootDescriptorIdentifier, () -> ((CompositeTypeImplementor)bootDescriptor.getIdentifierMapper().getType()).getMappingModelPart().getEmbeddableTypeDescriptor(), null, creationContext) : null)) : null;
        } else {
            this.mapsIdRepresentationStrategy = null;
            this.identifierPropertyName = identifierProperty.getName();
            this.identifierPropertyAccess = this.makePropertyAccess(identifierProperty);
        }
        BytecodeProvider bytecodeProvider = Environment.getBytecodeProvider();
        EntityMetamodel entityMetamodel = runtimeDescriptor.getEntityMetamodel();
        ProxyFactory proxyFactory = null;
        if (this.proxyJtd != null && entityMetamodel.isLazy() && (proxyFactory = this.createProxyFactory(bootDescriptor, bytecodeProvider, creationContext)) == null) {
            entityMetamodel.setLazy(false);
        }
        this.proxyFactory = proxyFactory;
        this.strategySelector = sessionFactory.getServiceRegistry().getService(StrategySelector.class);
        this.reflectionOptimizer = this.resolveReflectionOptimizer(bootDescriptor, bytecodeProvider, sessionFactory);
        this.instantiator = this.determineInstantiator(bootDescriptor, entityMetamodel);
    }

    private EntityInstantiator determineInstantiator(PersistentClass bootDescriptor, EntityMetamodel entityMetamodel) {
        if (this.reflectionOptimizer != null && this.reflectionOptimizer.getInstantiationOptimizer() != null) {
            ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer = this.reflectionOptimizer.getInstantiationOptimizer();
            return new EntityInstantiatorPojoOptimized(entityMetamodel, bootDescriptor, this.mappedJtd, instantiationOptimizer);
        }
        return new EntityInstantiatorPojoStandard(entityMetamodel, bootDescriptor, this.mappedJtd);
    }

    private ProxyFactory createProxyFactory(PersistentClass bootDescriptor, BytecodeProvider bytecodeProvider, RuntimeModelCreationContext creationContext) {
        Method idSetterMethod;
        Method idGetterMethod;
        HashSet<Class> proxyInterfaces = new HashSet<Class>();
        Class<?> mappedClass = this.mappedJtd.getJavaTypeClass();
        Class<?> proxyInterface = this.proxyJtd != null ? this.proxyJtd.getJavaTypeClass() : null;
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + bootDescriptor.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Iterator<Subclass> subclasses = bootDescriptor.getSubclassIterator();
        while (subclasses.hasNext()) {
            Subclass subclass = subclasses.next();
            Class<?> subclassProxy = subclass.getProxyInterface();
            Class<?> subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!subclassProxy.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        proxyInterfaces.add(HibernateProxy.class);
        Iterator<Property> properties = bootDescriptor.getPropertyIterator();
        Class<?> clazz = bootDescriptor.getMappedClass();
        try {
            while (properties.hasNext()) {
                Property property = properties.next();
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Getter", property.getGetter(clazz).getMethod());
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Setter", property.getSetter(clazz).getMethod());
            }
            if (this.identifierPropertyAccess != null) {
                idGetterMethod = this.identifierPropertyAccess.getGetter().getMethod();
                idSetterMethod = this.identifierPropertyAccess.getSetter().getMethod();
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Getter", idGetterMethod);
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Setter", idSetterMethod);
            } else {
                idGetterMethod = null;
                idSetterMethod = null;
            }
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(clazz.getName(), he);
            return null;
        }
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        ProxyFactory pf = bytecodeProvider.getProxyFactoryFactory().buildProxyFactory(creationContext.getSessionFactory());
        try {
            pf.postInstantiate(bootDescriptor.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, bootDescriptor.hasEmbeddedIdentifier() ? (CompositeType)bootDescriptor.getIdentifier().getType() : null);
            return pf;
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(bootDescriptor.getEntityName(), he);
            return null;
        }
    }

    private ReflectionOptimizer resolveReflectionOptimizer(PersistentClass bootType, BytecodeProvider bytecodeProvider, SessionFactoryImplementor sessionFactory) {
        Class<?> javaTypeToReflect;
        if (this.proxyFactory != null) {
            assert (this.proxyJtd != null);
            javaTypeToReflect = this.proxyJtd.getJavaTypeClass();
        } else {
            javaTypeToReflect = this.mappedJtd.getJavaTypeClass();
        }
        ArrayList<String> getterNames = new ArrayList<String>();
        ArrayList<String> setterNames = new ArrayList<String>();
        ArrayList getterTypes = new ArrayList();
        boolean foundCustomAccessor = false;
        Iterator<Property> itr = bootType.getPropertyClosureIterator();
        int i = 0;
        while (itr.hasNext()) {
            Property property = itr.next();
            PropertyAccess propertyAccess = this.makePropertyAccess(property);
            this.propertyAccessMap.put(property.getName(), propertyAccess);
            if (!(propertyAccess instanceof PropertyAccessBasicImpl)) {
                foundCustomAccessor = true;
            }
            getterNames.add(propertyAccess.getGetter().getMethodName());
            getterTypes.add(propertyAccess.getGetter().getReturnTypeClass());
            setterNames.add(propertyAccess.getSetter().getMethodName());
            ++i;
        }
        if (foundCustomAccessor || !Environment.useReflectionOptimizer()) {
            return null;
        }
        return bytecodeProvider.getReflectionOptimizer(javaTypeToReflect, getterNames.toArray(new String[0]), setterNames.toArray(new String[0]), getterTypes.toArray(new Class[0]));
    }

    private PropertyAccess makePropertyAccess(Property bootAttributeDescriptor) {
        PropertyAccessStrategy strategy = bootAttributeDescriptor.getPropertyAccessStrategy(this.mappedJtd.getJavaTypeClass());
        if (strategy == null) {
            String propertyAccessorName = bootAttributeDescriptor.getPropertyAccessorName();
            if (StringHelper.isNotEmpty(propertyAccessorName)) {
                strategy = this.strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
            } else if (bootAttributeDescriptor instanceof Backref) {
                Backref backref = (Backref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
            } else if (bootAttributeDescriptor instanceof IndexBackref) {
                IndexBackref indexBackref = (IndexBackref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
            } else {
                strategy = BuiltInPropertyAccessStrategies.MIXED.getStrategy();
            }
        }
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.mappedJtd.getJavaType().getTypeName(), bootAttributeDescriptor.getName()));
        }
        return strategy.buildPropertyAccess(this.mappedJtd.getJavaTypeClass(), bootAttributeDescriptor.getName(), true);
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return this.reflectionOptimizer;
    }

    @Override
    public EntityInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    @Override
    public boolean isBytecodeEnhanced() {
        return this.isBytecodeEnhanced;
    }

    @Override
    public JavaType<?> getMappedJavaTypeDescriptor() {
        return this.mappedJtd;
    }

    @Override
    public JavaType<?> getProxyJavaTypeDescriptor() {
        return this.proxyJtd;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        if (bootAttributeDescriptor.getName().equals(this.identifierPropertyName)) {
            return this.identifierPropertyAccess;
        }
        PropertyAccess propertyAccess = this.propertyAccessMap.get(bootAttributeDescriptor.getName());
        if (propertyAccess != null) {
            return propertyAccess;
        }
        if (this.mapsIdRepresentationStrategy != null) {
            return this.mapsIdRepresentationStrategy.resolvePropertyAccess(bootAttributeDescriptor);
        }
        return null;
    }
}

