/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.AttributeFactory;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.BasicTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public class MetadataContext {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(MetadataContext.class);
    private final JpaMetamodel jpaMetamodel;
    private final RuntimeModelCreationContext runtimeModelCreationContext;
    private Set<MappedSuperclass> knownMappedSuperclasses;
    private TypeConfiguration typeConfiguration;
    private final JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting;
    private final AttributeFactory attributeFactory = new AttributeFactory(this);
    private Map<Class<?>, EntityDomainType<?>> entityTypes = new HashMap();
    private Map<String, EntityDomainType<?>> entityTypesByEntityName = new HashMap();
    private Map<PersistentClass, EntityDomainType<?>> entityTypesByPersistentClass = new HashMap();
    private Map<Class, EmbeddableDomainType<?>> embeddables = new HashMap();
    private Map<Class, List<EmbeddableDomainType<?>>> embeddablesToProcess = new HashMap();
    private Map<EmbeddableDomainType<?>, Component> componentByEmbeddable = new HashMap();
    private Map<MappedSuperclass, MappedSuperclassDomainType<?>> mappedSuperclassByMappedSuperclassMapping = new HashMap();
    private Map<MappedSuperclassDomainType<?>, PersistentClass> mappedSuperClassTypeToPersistentClass = new HashMap();
    private List<Object> orderedMappings = new ArrayList<Object>();
    private List<PersistentClass> stackOfPersistentClassesBeingProcessed = new ArrayList<PersistentClass>();
    private MappingMetamodel metamodel;
    private final Set<Class> processedMetamodelClasses = new HashSet<Class>();
    private final Map<Class<?>, BasicDomainType<?>> basicDomainTypeMap = new HashMap();

    public MetadataContext(JpaMetamodel jpaMetamodel, MappingMetamodel mappingMetamodel, MetadataImplementor bootMetamodel, JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.jpaMetamodel = jpaMetamodel;
        this.metamodel = mappingMetamodel;
        this.knownMappedSuperclasses = bootMetamodel.getMappedSuperclassMappingsCopy();
        this.typeConfiguration = runtimeModelCreationContext.getTypeConfiguration();
        this.jpaStaticMetaModelPopulationSetting = jpaStaticMetaModelPopulationSetting;
        this.runtimeModelCreationContext = runtimeModelCreationContext;
    }

    public RuntimeModelCreationContext getRuntimeModelCreationContext() {
        return this.runtimeModelCreationContext;
    }

    public JpaMetamodel getJpaMetamodel() {
        return this.jpaMetamodel;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public JavaTypeRegistry getJavaTypeDescriptorRegistry() {
        return this.typeConfiguration.getJavaTypeDescriptorRegistry();
    }

    MappingMetamodel getMetamodel() {
        return this.metamodel;
    }

    public Map<Class<?>, EntityDomainType<?>> getEntityTypeMap() {
        return Collections.unmodifiableMap(this.entityTypes);
    }

    public Set<EmbeddableDomainType<?>> getEmbeddableTypeSet() {
        return new HashSet(this.embeddables.values());
    }

    public Map<Class<?>, MappedSuperclassDomainType<?>> getMappedSuperclassTypeMap() {
        HashMap<Class<?>, MappedSuperclassDomainType<?>> mappedSuperClassTypeMap = CollectionHelper.mapOfSize(this.mappedSuperclassByMappedSuperclassMapping.size());
        for (MappedSuperclassDomainType<?> mappedSuperclassType : this.mappedSuperclassByMappedSuperclassMapping.values()) {
            mappedSuperClassTypeMap.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
        }
        return mappedSuperClassTypeMap;
    }

    public void registerEntityType(PersistentClass persistentClass, EntityTypeImpl<?> entityType) {
        if (entityType.getBindableJavaType() != null) {
            this.entityTypes.put(entityType.getBindableJavaType(), entityType);
        }
        this.entityTypesByEntityName.put(persistentClass.getEntityName(), entityType);
        this.entityTypesByPersistentClass.put(persistentClass, entityType);
        this.orderedMappings.add(persistentClass);
    }

    public void registerEmbeddableType(EmbeddableDomainType<?> embeddableType, Component bootDescriptor) {
        assert (embeddableType.getJavaType() != null);
        assert (!Map.class.isAssignableFrom(embeddableType.getJavaType()));
        this.embeddablesToProcess.computeIfAbsent(embeddableType.getJavaType(), k -> new ArrayList(1)).add(embeddableType);
        this.registerComponentByEmbeddable(embeddableType, bootDescriptor);
    }

    public void registerComponentByEmbeddable(EmbeddableDomainType<?> embeddableType, Component bootDescriptor) {
        this.componentByEmbeddable.put(embeddableType, bootDescriptor);
    }

    public Component getEmbeddableBootDescriptor(EmbeddableDomainType<?> embeddableType) {
        return this.componentByEmbeddable.get(embeddableType);
    }

    public void registerMappedSuperclassType(MappedSuperclass mappedSuperclass, MappedSuperclassDomainType<?> mappedSuperclassType) {
        this.mappedSuperclassByMappedSuperclassMapping.put(mappedSuperclass, mappedSuperclassType);
        this.orderedMappings.add(mappedSuperclass);
        this.mappedSuperClassTypeToPersistentClass.put(mappedSuperclassType, this.getEntityWorkedOn());
        this.knownMappedSuperclasses.remove(mappedSuperclass);
    }

    public EntityDomainType<?> locateEntityType(PersistentClass persistentClass) {
        return this.entityTypesByPersistentClass.get(persistentClass);
    }

    public EntityDomainType<?> locateEntityType(Class<?> javaType) {
        return this.entityTypes.get(javaType);
    }

    public <E> EntityDomainType<E> locateEntityType(String entityName) {
        return this.entityTypesByEntityName.get(entityName);
    }

    public Map<String, EntityDomainType<?>> getEntityTypesByEntityName() {
        return Collections.unmodifiableMap(this.entityTypesByEntityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        PersistentAttribute attribute;
        Property property;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Wrapping up metadata context...");
        }
        boolean staticMetamodelScanEnabled = this.jpaStaticMetaModelPopulationSetting != JpaStaticMetaModelPopulationSetting.DISABLED;
        for (Object mapping : this.orderedMappings) {
            Iterator properties;
            if (PersistentClass.class.isAssignableFrom(mapping.getClass())) {
                PersistentClass persistentClass = (PersistentClass)mapping;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Starting entity [" + persistentClass.getEntityName() + "]");
                }
                try {
                    EntityDomainType<?> jpaMapping = this.entityTypesByPersistentClass.get(persistentClass);
                    this.applyIdMetadata(persistentClass, jpaMapping);
                    this.applyVersionAttribute(persistentClass, jpaMapping);
                    properties = persistentClass.getDeclaredPropertyIterator();
                    while (properties.hasNext()) {
                        property = properties.next();
                        if (property.getValue() == persistentClass.getIdentifierMapper() || persistentClass.isVersioned() && property == persistentClass.getVersion() || (attribute = this.attributeFactory.buildAttribute(jpaMapping, property)) == null) continue;
                        ((AttributeContainer)((Object)jpaMapping)).getInFlightAccess().addAttribute(attribute);
                    }
                    ((AttributeContainer)((Object)jpaMapping)).getInFlightAccess().finishUp();
                    if (!staticMetamodelScanEnabled) continue;
                    this.populateStaticMetamodel(jpaMapping);
                    continue;
                }
                finally {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Completed entity [" + persistentClass.getEntityName() + "]");
                    }
                    continue;
                }
            }
            if (MappedSuperclass.class.isAssignableFrom(mapping.getClass())) {
                MappedSuperclass mappedSuperclass = (MappedSuperclass)mapping;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Starting mapped superclass [" + mappedSuperclass.getMappedClass().getName() + "]");
                }
                try {
                    MappedSuperclassDomainType<?> jpaType = this.mappedSuperclassByMappedSuperclassMapping.get(mappedSuperclass);
                    this.applyIdMetadata(mappedSuperclass, jpaType);
                    this.applyVersionAttribute(mappedSuperclass, jpaType);
                    properties = mappedSuperclass.getDeclaredPropertyIterator();
                    while (properties.hasNext()) {
                        property = (Property)properties.next();
                        if (mappedSuperclass.isVersioned() && property == mappedSuperclass.getVersion() || (attribute = this.attributeFactory.buildAttribute(jpaType, property)) == null) continue;
                        ((AttributeContainer)((Object)jpaType)).getInFlightAccess().addAttribute(attribute);
                    }
                    ((AttributeContainer)((Object)jpaType)).getInFlightAccess().finishUp();
                    if (!staticMetamodelScanEnabled) continue;
                    this.populateStaticMetamodel(jpaType);
                    continue;
                }
                finally {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Completed mapped superclass [" + mappedSuperclass.getMappedClass().getName() + "]");
                    }
                    continue;
                }
            }
            throw new AssertionFailure("Unexpected mapping type: " + mapping.getClass());
        }
        while (!this.embeddablesToProcess.isEmpty()) {
            ArrayList processingEmbeddables = new ArrayList(this.embeddablesToProcess.size());
            for (List<EmbeddableDomainType<?>> list : this.embeddablesToProcess.values()) {
                processingEmbeddables.addAll(list);
            }
            this.embeddablesToProcess.clear();
            for (EmbeddableDomainType embeddableDomainType : processingEmbeddables) {
                Component component = this.componentByEmbeddable.get(embeddableDomainType);
                Iterator<Property> propertyItr = component.getPropertyIterator();
                while (propertyItr.hasNext()) {
                    property = propertyItr.next();
                    attribute = this.attributeFactory.buildAttribute(embeddableDomainType, property);
                    if (attribute == null) continue;
                    ((AttributeContainer)((Object)embeddableDomainType)).getInFlightAccess().addAttribute(attribute);
                }
                ((AttributeContainer)((Object)embeddableDomainType)).getInFlightAccess().finishUp();
                this.embeddables.put(embeddableDomainType.getJavaType(), embeddableDomainType);
                if (!staticMetamodelScanEnabled) continue;
                this.populateStaticMetamodel(embeddableDomainType);
            }
        }
    }

    private void applyIdMetadata(PersistentClass persistentClass, IdentifiableDomainType<?> identifiableType) {
        if (persistentClass.hasIdentifierProperty()) {
            Property declaredIdentifierProperty = persistentClass.getDeclaredIdentifierProperty();
            if (declaredIdentifierProperty != null) {
                SingularPersistentAttribute idAttribute = this.attributeFactory.buildIdAttribute(identifiableType, declaredIdentifierProperty);
                ((AttributeContainer)((Object)identifiableType)).getInFlightAccess().applyIdAttribute(idAttribute);
            }
        } else {
            EmbeddableTypeImpl<?> idClassType;
            int propertySpan;
            Iterator<Property> cidPropertyItr;
            if (!Component.class.isInstance(persistentClass.getIdentifier())) {
                throw new MappingException("Expecting Component for id mapping with no id-attribute");
            }
            Component cidValue = (Component)persistentClass.getIdentifier();
            Component identifierMapper = persistentClass.getIdentifierMapper();
            if (identifierMapper != null) {
                cidPropertyItr = identifierMapper.getPropertyIterator();
                propertySpan = identifierMapper.getPropertySpan();
                idClassType = this.applyIdClassMetadata((Component)persistentClass.getIdentifier());
            } else {
                cidPropertyItr = cidValue.getPropertyIterator();
                propertySpan = cidValue.getPropertySpan();
                idClassType = null;
            }
            assert (cidValue.isEmbedded());
            AbstractIdentifiableType idType = (AbstractIdentifiableType)((Object)this.entityTypesByEntityName.get(cidValue.getOwner().getEntityName()));
            Set idAttributes = idType.getIdClassAttributesSafely();
            if (idAttributes == null) {
                idAttributes = new HashSet(propertySpan);
                while (cidPropertyItr.hasNext()) {
                    Property cidSubProperty = cidPropertyItr.next();
                    SingularPersistentAttribute cidSubAttr = this.attributeFactory.buildIdAttribute(idType, cidSubProperty);
                    idAttributes.add(cidSubAttr);
                }
            }
            ((AttributeContainer)((Object)identifiableType)).getInFlightAccess().applyNonAggregatedIdAttributes(idAttributes, idClassType);
        }
    }

    private EmbeddableTypeImpl<?> applyIdClassMetadata(Component idClassComponent) {
        JavaTypeRegistry registry = this.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        Class componentClass = idClassComponent.getComponentClass();
        JavaType javaTypeDescriptor = registry.resolveManagedTypeDescriptor(componentClass);
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(javaTypeDescriptor, false, this.getJpaMetamodel());
        this.registerEmbeddableType(embeddableType, idClassComponent);
        return embeddableType;
    }

    private <X> void applyIdMetadata(MappedSuperclass mappingType, MappedSuperclassDomainType<X> jpaMappingType) {
        if (mappingType.hasIdentifierProperty()) {
            Property declaredIdentifierProperty = mappingType.getDeclaredIdentifierProperty();
            if (declaredIdentifierProperty != null) {
                SingularPersistentAttribute attribute = this.attributeFactory.buildIdAttribute(jpaMappingType, declaredIdentifierProperty);
                ((AttributeContainer)((Object)jpaMappingType)).getInFlightAccess().applyIdAttribute(attribute);
            }
        } else if (mappingType.getIdentifierMapper() != null) {
            Set attributes = this.buildIdClassAttributes(jpaMappingType, mappingType.getIdentifierMapper().getPropertyIterator());
            ((AttributeContainer)((Object)jpaMappingType)).getInFlightAccess().applyIdClassAttributes(attributes);
        }
    }

    private <X> void applyVersionAttribute(PersistentClass persistentClass, EntityDomainType<X> jpaEntityType) {
        Property declaredVersion = persistentClass.getDeclaredVersion();
        if (declaredVersion != null) {
            ((AttributeContainer)((Object)jpaEntityType)).getInFlightAccess().applyVersionAttribute(this.attributeFactory.buildVersionAttribute(jpaEntityType, declaredVersion));
        }
    }

    private <X> void applyVersionAttribute(MappedSuperclass mappingType, MappedSuperclassDomainType<X> jpaMappingType) {
        Property declaredVersion = mappingType.getDeclaredVersion();
        if (declaredVersion != null) {
            ((AttributeContainer)((Object)jpaMappingType)).getInFlightAccess().applyVersionAttribute(this.attributeFactory.buildVersionAttribute(jpaMappingType, declaredVersion));
        }
    }

    private <X> Set<SingularPersistentAttribute<? super X, ?>> buildIdClassAttributes(IdentifiableDomainType<X> ownerType, Iterator<Property> propertyIterator) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Building old-school composite identifier [" + ownerType.getJavaType().getName() + "]");
        }
        HashSet attributes = new HashSet();
        while (propertyIterator.hasNext()) {
            attributes.add(this.attributeFactory.buildIdAttribute(ownerType, propertyIterator.next()));
        }
        return attributes;
    }

    private <X> void populateStaticMetamodel(ManagedDomainType<X> managedType) {
        Class managedTypeClass = managedType.getJavaType();
        if (managedTypeClass == null) {
            return;
        }
        String metamodelClassName = managedTypeClass.getName() + "_";
        try {
            Class<?> metamodelClass = Class.forName(metamodelClassName, true, managedTypeClass.getClassLoader());
            this.registerAttributes(metamodelClass, managedType);
        }
        catch (ClassNotFoundException metamodelClass) {
            // empty catch block
        }
        ManagedDomainType<X> superType = managedType.getSuperType();
        if (superType != null) {
            this.populateStaticMetamodel(superType);
        }
    }

    private <X> void registerAttributes(Class metamodelClass, ManagedDomainType<X> managedType) {
        if (!this.processedMetamodelClasses.add(metamodelClass)) {
            return;
        }
        for (Attribute attribute : managedType.getDeclaredAttributes()) {
            this.registerAttribute(metamodelClass, attribute);
        }
        if (managedType instanceof IdentifiableType) {
            Set attributes;
            AbstractIdentifiableType entityType = (AbstractIdentifiableType)managedType;
            if (entityType.hasDeclaredVersionAttribute()) {
                this.registerAttribute(metamodelClass, (Attribute<X, ?>)entityType.getDeclaredVersion());
            }
            if (entityType.hasIdClass() && (attributes = entityType.getIdClassAttributesSafely()) != null) {
                for (SingularAttribute singularAttribute : attributes) {
                    this.registerAttribute(metamodelClass, (Attribute<X, ?>)singularAttribute);
                }
            }
        }
    }

    private <X> void registerAttribute(Class metamodelClass, Attribute<X, ?> attribute) {
        String name = attribute.getName();
        try {
            boolean allowNonDeclaredFieldReference = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED || attribute.getDeclaringType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE;
            Field field = allowNonDeclaredFieldReference ? metamodelClass.getField(name) : metamodelClass.getDeclaredField(name);
            try {
                ReflectHelper.ensureAccessibility(field);
                field.set(null, attribute);
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Unable to inject static metamodel attribute : " + metamodelClass.getName() + "#" + name, e);
            }
            catch (IllegalArgumentException e) {
                LOG.illegalArgumentOnStaticMetamodelFieldInjection(metamodelClass.getName(), name, attribute.getClass().getName(), field.getType().getName());
            }
        }
        catch (NoSuchFieldException e) {
            LOG.unableToLocateStaticMetamodelField(metamodelClass.getName(), name);
        }
    }

    public MappedSuperclassDomainType<?> locateMappedSuperclassType(MappedSuperclass mappedSuperclass) {
        return this.mappedSuperclassByMappedSuperclassMapping.get(mappedSuperclass);
    }

    public void pushEntityWorkedOn(PersistentClass persistentClass) {
        this.stackOfPersistentClassesBeingProcessed.add(persistentClass);
    }

    public void popEntityWorkedOn(PersistentClass persistentClass) {
        PersistentClass stackTop = this.stackOfPersistentClassesBeingProcessed.remove(this.stackOfPersistentClassesBeingProcessed.size() - 1);
        if (stackTop != persistentClass) {
            throw new AssertionFailure("Inconsistent popping: " + persistentClass.getEntityName() + " instead of " + stackTop.getEntityName());
        }
    }

    private PersistentClass getEntityWorkedOn() {
        return this.stackOfPersistentClassesBeingProcessed.get(this.stackOfPersistentClassesBeingProcessed.size() - 1);
    }

    public PersistentClass getPersistentClassHostingProperties(MappedSuperclassTypeImpl<?> mappedSuperclassType) {
        PersistentClass persistentClass = this.mappedSuperClassTypeToPersistentClass.get(mappedSuperclassType);
        if (persistentClass == null) {
            throw new AssertionFailure("Could not find PersistentClass for MappedSuperclassType: " + mappedSuperclassType.getJavaType());
        }
        return persistentClass;
    }

    public Set<MappedSuperclass> getUnusedMappedSuperclasses() {
        return new HashSet<MappedSuperclass>(this.knownMappedSuperclasses);
    }

    public <J> BasicDomainType<J> resolveBasicType(Class<J> javaType) {
        return this.basicDomainTypeMap.computeIfAbsent(javaType, jt -> {
            JavaTypeRegistry registry = this.getTypeConfiguration().getJavaTypeDescriptorRegistry();
            return new BasicTypeImpl(registry.resolveDescriptor(javaType));
        });
    }

    public <J> EmbeddableDomainType<J> locateEmbeddable(Class<J> embeddableClass, Component component) {
        Iterator<EmbeddableDomainType<?>> iterator;
        List<EmbeddableDomainType<?>> embeddableDomainTypes;
        EmbeddableDomainType<?> domainType = this.embeddables.get(embeddableClass);
        if (domainType == null && (embeddableDomainTypes = this.embeddablesToProcess.get(embeddableClass)) != null && (iterator = embeddableDomainTypes.iterator()).hasNext()) {
            EmbeddableDomainType<?> embeddableDomainType = iterator.next();
            Component cachedComponent = this.componentByEmbeddable.get(embeddableDomainType);
            if (cachedComponent.isSame(component)) {
                domainType = embeddableDomainType;
            } else if (cachedComponent.getComponentClass().equals(component.getComponentClass())) {
                int cachedComponentPropertySpan = cachedComponent.getPropertySpan();
                if (cachedComponentPropertySpan != component.getPropertySpan()) {
                    throw new MappingException("Encountered multiple component mappings for the same java class " + embeddableClass.getName() + " with different property mappings. Every property mapping combination should have its own java class");
                }
                for (int i = 0; i < cachedComponentPropertySpan; ++i) {
                    if (cachedComponent.getProperty(i).getName().equals(component.getProperty(i).getName())) continue;
                    throw new MappingException("Encountered multiple component mappings for the same java class " + embeddableClass.getName() + " with different property mappings. Every property mapping combination should have its own java class");
                }
                domainType = embeddableDomainType;
            } else {
                throw new MappingException("Encountered multiple component mappings for the same java class " + embeddableClass.getName() + " with different property mappings. Every property mapping combination should have its own java class");
            }
        }
        return domainType;
    }
}

