/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;

public class CaseStatementDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping {
    private final LinkedHashMap<String, TableDiscriminatorDetails> tableDiscriminatorDetailsMap = new LinkedHashMap();

    public CaseStatementDiscriminatorMappingImpl(JoinedSubclassEntityPersister entityDescriptor, String[] tableNames, int[] notNullColumnTableNumbers, String[] notNullColumnNames, String[] discriminatorValues, Map<String, String> subEntityNameByTableName, DiscriminatorType<?> incomingDiscriminatorType, MappingModelCreationProcess creationProcess) {
        super(incomingDiscriminatorType.getUnderlyingType().getJdbcMapping(), entityDescriptor, incomingDiscriminatorType, creationProcess);
        for (int i = 0; i < discriminatorValues.length; ++i) {
            String tableName = tableNames[notNullColumnTableNumbers[i]];
            String subEntityName = subEntityNameByTableName.get(tableName);
            String oneSubEntityColumn = notNullColumnNames[i];
            String rawDiscriminatorValue = discriminatorValues[i];
            Object discriminatorValue = this.getUnderlyingJdbcMappingType().getJavaTypeDescriptor().wrap(rawDiscriminatorValue, null);
            this.tableDiscriminatorDetailsMap.put(tableName, new TableDiscriminatorDetails(tableName, oneSubEntityColumn, discriminatorValue, subEntityName));
        }
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public BasicFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        this.tableDiscriminatorDetailsMap.forEach((tableName, tableDiscriminatorDetails) -> tableGroup.getTableReference(fetchablePath, (String)tableName, false, true));
        return super.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        return expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getSelectionExpression()), sqlAstProcessingState -> this.createCaseSearchedExpression(tableGroup));
    }

    private Expression createCaseSearchedExpression(final TableGroup entityTableGroup) {
        return new SelfRenderingExpression(){
            CaseSearchedExpression caseSearchedExpression;

            @Override
            public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                if (this.caseSearchedExpression == null) {
                    this.caseSearchedExpression = new CaseSearchedExpression(CaseStatementDiscriminatorMappingImpl.this);
                    CaseStatementDiscriminatorMappingImpl.this.tableDiscriminatorDetailsMap.forEach((tableName, tableDiscriminatorDetails) -> {
                        TableReference tableReference = entityTableGroup.getTableReference(entityTableGroup.getNavigablePath(), (String)tableName, false, false);
                        if (tableReference == null) {
                            return;
                        }
                        NullnessPredicate predicate = new NullnessPredicate(new ColumnReference(tableReference, tableDiscriminatorDetails.getCheckColumnName(), false, null, null, CaseStatementDiscriminatorMappingImpl.this.getJdbcMapping(), CaseStatementDiscriminatorMappingImpl.this.getSessionFactory()), true);
                        this.caseSearchedExpression.when(predicate, new QueryLiteral<Object>(tableDiscriminatorDetails.getDiscriminatorValue(), CaseStatementDiscriminatorMappingImpl.this.getUnderlyingJdbcMappingType()));
                    });
                }
                this.caseSearchedExpression.accept(walker);
            }

            @Override
            public JdbcMappingContainer getExpressionType() {
                return CaseStatementDiscriminatorMappingImpl.this;
            }
        };
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getContainingTableExpression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSelectionExpression() {
        return "{discriminator}";
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    private static class TableDiscriminatorDetails {
        private final String tableName;
        private final String checkColumnName;
        private final Object discriminatorValue;
        private final String subclassEntityName;

        public TableDiscriminatorDetails(String tableName, String checkColumnName, Object discriminatorValue, String subclassEntityName) {
            this.tableName = tableName;
            this.checkColumnName = checkColumnName;
            this.discriminatorValue = discriminatorValue;
            this.subclassEntityName = subclassEntityName;
        }

        String getTableExpression() {
            return this.tableName;
        }

        Object getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        String getSubclassEntityName() {
            return this.subclassEntityName;
        }

        String getCheckColumnName() {
            return this.checkColumnName;
        }
    }
}

