/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptorSide;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddedForeignKeyDescriptor
implements ForeignKeyDescriptor {
    private final EmbeddedForeignKeyDescriptorSide keySide;
    private final EmbeddedForeignKeyDescriptorSide targetSide;
    private final String keyTable;
    private final SelectableMappings keySelectableMappings;
    private final String targetTable;
    private final SelectableMappings targetSelectableMappings;
    private final AssociationKey associationKey;
    private final boolean hasConstraint;

    public EmbeddedForeignKeyDescriptor(EmbeddableValuedModelPart keyMappingType, EmbeddableValuedModelPart targetMappingType, String keyTable, SelectableMappings keySelectableMappings, String targetTable, SelectableMappings targetSelectableMappings, boolean hasConstraint, MappingModelCreationProcess creationProcess) {
        this.keyTable = keyTable;
        this.keySelectableMappings = keySelectableMappings;
        this.targetTable = targetTable;
        this.targetSelectableMappings = targetSelectableMappings;
        this.targetSide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetMappingType);
        this.keySide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, keyMappingType);
        ArrayList<String> columns = new ArrayList<String>(keySelectableMappings.getJdbcTypeCount());
        keySelectableMappings.forEachSelectable((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
        this.associationKey = new AssociationKey(keyTable, columns);
        this.hasConstraint = hasConstraint;
        creationProcess.registerInitializationCallback("Embedded (composite) FK descriptor " + targetMappingType.getNavigableRole(), () -> {
            List<AttributeMapping> subAttributes = targetMappingType.getEmbeddableTypeDescriptor().getAttributeMappings();
            return !subAttributes.isEmpty();
        });
    }

    private EmbeddedForeignKeyDescriptor(EmbeddedForeignKeyDescriptor original, String keyTable, ManagedMappingType keyDeclaringType, TableGroupProducer keyDeclaringTableGroupProducer, SelectableMappings keySelectableMappings, MappingModelCreationProcess creationProcess) {
        this.keyTable = keyTable;
        this.keySelectableMappings = keySelectableMappings;
        this.targetTable = original.targetTable;
        this.targetSelectableMappings = original.targetSelectableMappings;
        this.targetSide = original.targetSide;
        this.keySide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, EmbeddedAttributeMapping.createInverseModelPart(original.targetSide.getModelPart(), keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess));
        ArrayList<String> columns = new ArrayList<String>(keySelectableMappings.getJdbcTypeCount());
        keySelectableMappings.forEachSelectable((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
        this.associationKey = new AssociationKey(keyTable, columns);
        this.hasConstraint = original.hasConstraint;
    }

    @Override
    public String getKeyTable() {
        return this.keyTable;
    }

    @Override
    public String getTargetTable() {
        return this.targetTable;
    }

    @Override
    public ModelPart getKeyPart() {
        return this.keySide.getModelPart().getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
    }

    @Override
    public ModelPart getTargetPart() {
        return this.targetSide.getModelPart().getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
    }

    @Override
    public ForeignKeyDescriptor.Side getKeySide() {
        return this.keySide;
    }

    @Override
    public ForeignKeyDescriptor.Side getTargetSide() {
        return this.targetSide;
    }

    @Override
    public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer, IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
        SelectableMapping[] selectionMappings = new SelectableMapping[this.keySelectableMappings.getJdbcTypeCount()];
        for (int i = 0; i < selectionMappings.length; ++i) {
            selectionMappings[i] = selectableMappingAccess.apply(i);
        }
        return new EmbeddedForeignKeyDescriptor(this, selectionMappings[0].getContainingTableExpression(), declaringType, declaringTableGroupProducer, new SelectableMappingsImpl(selectionMappings), creationProcess);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, null, this.keyTable, this.keySide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        assert (tableGroup.getTableReference(navigablePath, this.targetTable) != null);
        return this.createDomainResult(navigablePath, tableGroup, null, this.targetTable, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.targetTable.equals(this.keyTable)) {
            return this.createDomainResult(collectionPath, tableGroup, null, this.targetTable, this.targetSide.getModelPart(), creationState);
        }
        return this.createDomainResult(collectionPath, tableGroup, null, this.keyTable, this.keySide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, ForeignKeyDescriptor.Nature side, DomainResultCreationState creationState) {
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return this.createDomainResult(navigablePath, tableGroup, null, this.keyTable, this.keySide.getModelPart(), creationState);
        }
        return this.createDomainResult(navigablePath, tableGroup, null, this.targetTable, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, resultVariable, this.keyTable, this.keySide.getModelPart(), creationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, String columnContainingTable, EmbeddableValuedModelPart modelPart, DomainResultCreationState creationState) {
        ModelPartContainer parentModelPart;
        NavigablePath fkNavigablePath = navigablePath.append(this.getPartName());
        NavigablePath resultNavigablePath = this.associationKey.getTable().equals(columnContainingTable) ? ((parentModelPart = tableGroup.getModelPart()) instanceof PluralAttributeMapping ? (((PluralAttributeMapping)parentModelPart).getIndexDescriptor() == null ? navigablePath.append(CollectionPart.Nature.ELEMENT.getName()).append(this.getPartName()) : navigablePath.append(CollectionPart.Nature.INDEX.getName()).append(this.getPartName())) : navigablePath.append(this.getPartName())) : navigablePath.append(this.getPartName());
        TableGroup fkTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(resultNavigablePath, np -> {
            TableGroupJoin tableGroupJoin = modelPart.createTableGroupJoin(resultNavigablePath, tableGroup, null, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            tableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        if (fkNavigablePath != resultNavigablePath) {
            creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(fkNavigablePath, np -> fkTableGroup);
        }
        ForeignKeyDescriptor.Nature currentForeignKeyResolvingKey = creationState.getCurrentlyResolvingForeignKeyPart();
        try {
            creationState.setCurrentlyResolvingForeignKeyPart(this.keySide.getModelPart() == modelPart ? ForeignKeyDescriptor.Nature.KEY : ForeignKeyDescriptor.Nature.TARGET);
            EmbeddableForeignKeyResultImpl embeddableForeignKeyResultImpl = new EmbeddableForeignKeyResultImpl(resultNavigablePath, modelPart, resultVariable, creationState);
            return embeddableForeignKeyResultImpl;
        }
        finally {
            creationState.setCurrentlyResolvingForeignKeyPart(currentForeignKeyResolvingKey);
        }
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup targetSideTableGroup, TableGroup keySideTableGroup, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference lhsTableReference = targetSideTableGroup.resolveTableReference(targetSideTableGroup.getNavigablePath(), this.targetTable);
        TableReference rhsTableKeyReference = keySideTableGroup.resolveTableReference(this.keyTable);
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlAstJoinType, sqlExpressionResolver, creationContext);
    }

    @Override
    public Predicate generateJoinPredicate(TableReference targetSideReference, TableReference keySideReference, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        return this.getPredicate(targetSideReference, keySideReference, creationContext, this.targetSelectableMappings, this.keySelectableMappings);
    }

    private Predicate getPredicate(TableReference lhs, TableReference rhs, SqlAstCreationContext creationContext, SelectableMappings lhsMappings, SelectableMappings rhsMappings) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        lhsMappings.forEachSelectable((i, selection) -> {
            ComparisonPredicate comparisonPredicate = new ComparisonPredicate(new ColumnReference(lhs, selection, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, rhsMappings.getSelectable(i), creationContext.getSessionFactory()));
            predicate.add(comparisonPredicate);
        });
        return predicate;
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        TableReference tableReference = lhs.getPrimaryTableReference().resolveTableReference(table);
        if (tableReference != null) {
            return tableReference;
        }
        tableReference = tableGroup.getPrimaryTableReference().resolveTableReference(table);
        if (tableReference != null) {
            return tableReference;
        }
        tableReference = lhs.resolveTableReference(lhs.getNavigablePath().append(this.getNavigableRole().getNavigableName()), table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public int visitKeySelectables(int offset, SelectableConsumer consumer) {
        return this.keySelectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
        return this.targetSelectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public boolean hasConstraint() {
        return this.hasConstraint;
    }

    @Override
    public AssociationKey getAssociationKey() {
        return this.associationKey;
    }

    @Override
    public MappingType getMappedType() {
        return this.getPartMappingType();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.targetSide.getModelPart().getPartMappingType();
    }

    @Override
    public JavaType<?> getJavaTypeDescriptor() {
        return this.targetSide.getModelPart().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.targetSide.getModelPart().getNavigableRole();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        assert (domainValue instanceof Object[]);
        Object[] values = (Object[])domainValue;
        this.keySelectableMappings.forEachSelectable((index, selectable) -> valueConsumer.consume(values[index], selectable));
    }

    @Override
    public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Nature nature, SharedSessionContractImplementor session) {
        EmbeddableValuedModelPart modelPart = nature == ForeignKeyDescriptor.Nature.KEY ? this.keySide.getModelPart() : this.targetSide.getModelPart();
        if (modelPart instanceof SingleAttributeIdentifierMapping) {
            return ((SingleAttributeIdentifierMapping)((Object)modelPart)).getIdentifier(targetObject, session);
        }
        if (modelPart instanceof CompositeIdentifierMapping) {
            return ((CompositeIdentifierMapping)((Object)modelPart)).getIdentifier(targetObject, session);
        }
        return targetObject;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.targetSide.getModelPart().findContainingEntityMapping();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.targetSide.getModelPart().forEachJdbcType(offset, action);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.targetSide.getModelPart().forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.targetSide.getModelPart().disassemble(value, session);
    }
}

